#include <Arduino.h>

/*Batteriewaechter V2
 Autor: Frank Sommer (DC8FG)
 April 2017
 Aktualisiert: 11.03.2025
*/

#include <Wire.h>
#include <LiquidCrystal_I2C.h>

#include <EEPROM.h>

//int tim = 500; //the value of delay time - scheint wichtig für die Initialisierung des Displays - oder auch nicht
LiquidCrystal_I2C lcd(0x27, 16, 2);
//LiquidCrystal_I2C lcd(0x3F, 16, 2);


float Uref; /*Spannung an AVCC als Referenz fuer die Spannungsberechnung (Eingangsspannung im Vergleich zur Referenzspannung) - sollte gemessen werden fuer maximale Genauigkeit 
					 bei der Umrechnung (am Pin Spannungsversorgung fuer den ADC).
					 Wichtig: Der Widerstand an Vcc kann entfallen, wenn eine saubere Gleichspannung anliegt. So reduziert sich die
					 Spannung nicht. Bei anderen Schaltungen in denen St?rungen auftreten koennen, empfiehlt es sich, Vcc ueber einen Tiefpassfilter oder
					 wie bei aelteren Arduino-Boards - Ueber eine 100 mikroH Induktivitaet zu speisen.
					 Es muss immer die Spannung am ADC gemessen und dieser Wert hiert eingetragen werden. 
				   */

float Voltage_raw; //Counts (0-1023) des ADC je nach an ADC(0) aus dem Spannungsteiler anliegender Spannung
float Voltage_R2; //fuer die Umrechnung
float Voltage_in;
float Voltage_aref_in;
float Voltage_aref_raw; //fuer die Aus dem Spannungsteiler R1/R2 gewonnene Spannung zur "Kalibrierung" des ADC-Wertes
int mem_addr_overvolt = 0;//Speicherstelle fuer den Spannungswert im EEPROM
int mem_addr_normvolt = 4;//Speicherstelle fuer den Spannungswert im EEPROM
int mem_addr_chargevolt = 8;//Speicherstelle fuer den Spannungswert im EEPROM
int mem_addr_cutoffvolt = 16;//Speicherstelle fuer den Spannungswert im EEPROM
int mem_addr_Uref = 20; //Speicherstelle fuer den Referenzspannunsgwert Uref als Rechenvariable
float U_Overvolt; //= 13.9; //Abschaltgrenze Ueberspannung
float U_Norm; //= 12.0; //Untere Grenze normaler Spannungsbereich und Wiedereinschaltspannung nach Unterspannungsabschaltung
float U_Charge; //= 11.9; //Warngrenze Ladung erforderlich
float U_Cutoff; //= 11.9; //Abschaltspannung - Lasttrennung
float U_Ref; //Referenzspannungswert
int Pin_U_batt = 0;
int PIN_U_batt2 = 2;//Hier wird die Spannung aus dem Spannunsgteiler R1/R2 aufgelegt - dient fuer den Referenzspannunsgwert Uref als Rechenvariable
int LED_power_low = 10; //standardm??ig nicht beschaltet und keine Routine programmiert
int LED_power_weak = 9; //standardm??ig nicht beschaltet und keine Routine programmiert
int LED_power_good = 8; //standardm??ig nicht beschaltet und keine Routine programmiert
int Pin_buzzer = 7;
int Pin_relais = 6;
int Pin_bistab_switch = 2; //Taster um den Schaltzustand des bistabilen Relais manuell zu schalten
int status_Pin_bistab_switch;
int Pin_charge_led = 3; //LED bei Ladewarnung einschalten
int status_Pin_charge_led;

int Pin_bistabrelais_1 = 8; //Zur Ansteuerung von RE1 auf der Relaisplatine um das bistabile Lastrelais einzuschalten 
int Pin_bistabrelais_2 = 9; //Zur Ansteuerung von RE2 auf der Relaisplatine um das bistabile Lastrelais auszuschalten
int status_bistabrelais_1 = 0;
int status_bistabrelais_2 = 0;


int Status_Pin_relais; //Zur Ansteuerung des MOSFET T2 
int timer; //Timer fuer den Cut-Off-Prozess
int set_Taster = 15; //Set-Taster auf A1 (nur aus platinendesgntechnischen Gr?nden ist dieser Pin verwendet - geht sonst jeder andere auch ;-)
int status_set_Taster;
int set_menu;
void setup();
void loop();
void read_voltage_level();
void Voltage_Settings();
void learn_Over_voltage();
void learn_Norm_voltage();
void learn_Charge_voltage();
void learn_Cut_Off_voltage();
void learn_aref_voltage();
void adjust_voltage();
void adjust_aref_voltage();
void learn_reset_voltage();
void do_Reset();
void prewarning();
void midwarning();
void cofwarning();
void countdownwarning();
int midwarningcounter; //Zähler fuer die erste Ladewarnung (prewarning) damit er nur viermal piepst in der Schleife
int cofwarningcounter;

void setup()
{

  Serial.begin(9600);
	lcd.init();
	lcd.setBacklight(255);// Helligkeit der Hintergrundbeleuchtung des LCD-Displays
	
  pinMode(LED_power_low, OUTPUT);
	pinMode(LED_power_weak, OUTPUT);
	pinMode(LED_power_good, OUTPUT);
	pinMode(Pin_buzzer, OUTPUT);
	pinMode(Pin_relais, OUTPUT); //Zur Ansteuerung des MOSFET T2
  pinMode(Pin_bistab_switch, INPUT_PULLUP); //Taster zum manuellen Schalten des bistabilen Relais
  pinMode(Pin_charge_led, OUTPUT); //LED Ladewarnung

  pinMode(Pin_bistabrelais_1, OUTPUT); //Zur Ansteuerung von RE1 auf der Relaisplatine um das bistabile Lastrelais einzuschalten  
  pinMode(Pin_bistabrelais_2, OUTPUT); //Zur Ansteuerung von RE2 auf der Relaisplatine um das bistabile Lastrelais auszuschalten
	
  pinMode(set_Taster, INPUT_PULLUP); //Internen Pullup-Widerstand des Tasters fuer die Set-Abfrage aktivieren	
	
	//Ausgabe der Versionsinfo
	digitalWrite(Pin_buzzer, HIGH);
	delay(100);
	digitalWrite(Pin_buzzer, LOW);
	delay(100);
	lcd.home();
	lcd.print("Battery-Watchdog");
	lcd.setCursor(0, 1);
	lcd.print("    Ver. 2.0    ");
	delay(1000);
	lcd.home();
	lcd.print("    by DC8FG    ");
	lcd.setCursor(0, 1);
	lcd.print("   2017-2025    ");
	delay(1000);
  /*
  lcd.home();//Eigentuemerinformation
  lcd.print("     Owner:      "); //Eigentuemerinformation
  lcd.setCursor(0, 1);
  lcd.print("     xxxxxx      ");  
  delay(2000); 
	*/
  digitalWrite(Pin_buzzer, HIGH);
	delay(100); 
	digitalWrite(Pin_buzzer, LOW);
	delay(100);
	
		
	// ------------------------------------------------- Einlesen und uebernehmen der Schwellenwerte aus dem EEPROM (Mittels der Setup-Routinen gespeicherte Werte) ** muss auch für den Reset aktiviert werden -------------
	//.get liest "irgendeinen" Wert so auch float-Variablen - das geht nicht mit ".read"
	
   U_Overvolt = EEPROM.get(mem_addr_overvolt, U_Overvolt);
	 U_Norm = EEPROM.get(mem_addr_normvolt, U_Norm);
	 U_Charge = EEPROM.get(mem_addr_chargevolt, U_Charge);
	 U_Cutoff = EEPROM.get(mem_addr_cutoffvolt, U_Cutoff);
	 Uref = EEPROM.get(mem_addr_Uref, Uref);
	
  // --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


  // ----------------------------------------------------------------- Einlesen der nachfolgenden Schwellwerte ** Auskommentieren für den Reset -------------------------------------------------------------------------
  /*
  U_Overvolt = 13.9; //Abschaltgrenze Ueberspannung
  U_Norm= 12.0; //Untere Grenze normaler Spannungsbereich und Wiedereinschaltspannung nach Unterspannungsabschaltung
  U_Charge = 11.2; //Warngrenze Ladung erforderlich
  U_Cutoff = 10.7; //Abschaltspannung - Lasttrennung
  Uref = 5.00; //Referenzspannungswert
  */
  // ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
																
	
  //Ausgabe der Schwellenwerte zur Info/Kontrolle 
	 lcd.home();
	 lcd.print("Over-Voltage    ");
	 lcd.setCursor(0, 1);
	 lcd.print("set to : ");
	 lcd.print(U_Overvolt,1);
	 lcd.print(" V");
	 delay(1000);
	 lcd.home();
	 lcd.print("Norm-Voltage    ");
	 lcd.setCursor(0, 1);
	 lcd.print("set to : ");
	 lcd.print(U_Norm,1);
	 lcd.print(" V");
	 delay(1000);
	 lcd.home();
	 lcd.print("Charge-Voltage  ");
	 lcd.setCursor(0, 1);
	 lcd.print("set to : ");
	 lcd.print(U_Charge,1);
	 lcd.print(" V");
	 delay(1000);
	 lcd.home();
	 lcd.print("Cut-Off-Voltage ");
	 lcd.setCursor(0, 1);
	 lcd.print("set to : ");
	 lcd.print(U_Cutoff,1);
	 lcd.print(" V");
	 delay(1000);
	 
	 lcd.home();
	 lcd.print("Aref-Voltage    ");
	 lcd.setCursor(0, 1);
	 lcd.print("set to : ");
	 lcd.print(Uref);
	 lcd.print(" V");
	 delay(500);
   
}

void loop()
{ 
  
	timer = 0; //Timerwert fuer die Cut-Off-Sequenz zuruecksetzen wenn Bedingung fuer Cut-Off nicht mehr vorliegt

  // -----------------------------------------------------------  Taster fuer manuelles Ausschalten des Kontrollgeraetes ------------------------------------------------------
  
  status_Pin_bistab_switch = digitalRead(Pin_bistab_switch);
  if (status_Pin_bistab_switch == LOW)
  {
     digitalWrite(Pin_bistabrelais_2, HIGH);
      delay(1000);
      digitalWrite(Pin_bistabrelais_2, LOW);
      status_bistabrelais_2 = 0;
      status_bistabrelais_1 = 1;

    lcd.home();
		lcd.print("  Disconnected  ");
		//lcd.print(Voltage_in,1); //Wert nur mit einer Nachkommastelle ausgeben -> ,1 anhaengen
		//lcd.print(" V");
		lcd.setCursor(0, 1);
		lcd.print("Switch off Main");
		delay(60000);
	}
  
			
	//Set-Taster gedrueckt ?	
	status_set_Taster = digitalRead(set_Taster);
	if (status_set_Taster == LOW)
	{
		Voltage_Settings(); //Wenn ja - Aufruf der Funktion "Voltage_Settings" ansonsten weiter mit 2)
	}
	
	// -------------------------------------------------------------------------------------------------- Wie ist das aktuelle Spannungslevel?
  read_voltage_level();
  
	// -------------------------------------------------------------------------------------------------------- Pruefen auf Ueberspannung 
	if (Voltage_in > U_Overvolt) 
	{
		// Betrifft Schalten von T2
     //digitalWrite(Pin_relais, LOW); 
		 digitalWrite(Pin_charge_led, HIGH);
     status_Pin_charge_led = 1;
     // Einmaliges Schalten von Pin 9 (PB1)
    if (status_bistabrelais_2 == 0)  {
      digitalWrite(Pin_bistabrelais_2, HIGH);
      delay(1000);
      digitalWrite(Pin_bistabrelais_2, LOW);
      status_bistabrelais_2 = 1;
      status_bistabrelais_1 = 0;
    }
	  
  	prewarning(); // ---------------------------------------------------------------------------------------- Aufruf Routine fuer Warntoene
		
		lcd.home();
		lcd.print("U Batt.: ");
		lcd.print(Voltage_in,1); //Wert nur mit einer Nachkommastelle ausgeben -> ,1 anhaengen
		lcd.print(" V");
		lcd.setCursor(0, 1);
		lcd.print("  Overvoltage!  ");
		delay(1000);
		
		lcd.home();
		lcd.print("      Load     ");
		lcd.setCursor(0, 1);
		lcd.print("  Disconnected ");
		delay(1000);
	}

	// --------------------------------------------------------------------------------------------------- Pruefen ob Spannung im Normbereich
	if (Voltage_in < U_Overvolt && Voltage_in >= U_Charge)
	{
    // Betrifft Schalten von T2
    //digitalWrite(Pin_relais, HIGH);

    // LED Ladewarnung ausschalten
    //digitalRead(status_Pin_charge_led);   
    if (status_Pin_charge_led == 1) {
      digitalWrite(Pin_charge_led, LOW);
    }

     // Einmaliges Schalten von Pin 8 (PB0)
    if (status_bistabrelais_1 == 0)  {
      digitalWrite(Pin_bistabrelais_1, HIGH);
      delay(1000);
      digitalWrite(Pin_bistabrelais_1, LOW);
      status_bistabrelais_1 = 1;
      status_bistabrelais_2 = 0;
    }
  
    // ---------------------------------------------------------------------------------------------- Ausgabe des aktuellen Spannungslevels   
    lcd.home();
    lcd.print("U Batt.: ");
    lcd.print(Voltage_in,2); //Wert nur mit einer Nachkommastelle ausgeben -> ,1 anhaengen
    lcd.print(" V");
		lcd.setCursor(0, 1);
		lcd.print("Voltage ok        ");
		delay(200);
    midwarningcounter = 0;
		
	}
	
	
	// --------------------------------------------------------------------------------------- Pruefen ob Spannung unter Normbereich aber noch ueber Ladespannung
	//if (Voltage_in < U_Norm /*&& Voltage_in == U_Charge*/)
	//{
  //lcd.home();
    //lcd.print("U Batt.: ");
    //lcd.print(Voltage_in,1); //Wert nur mit einer Nachkommastelle ausgeben -> ,1 anhaengen
    //lcd.print(" V");
		//lcd.setCursor(0, 1);
		//lcd.print("Charge Battery!");
    //cofwarningcounter = 0;
    //while (midwarningcounter < 4) {    
    //  midwarning();
   // }
       
	//}
	
	
	// -------------------------------------------------------------------------------------------------- Pruefen ob Spannung die Ladespannung erreicht hat
	if (Voltage_in < U_Charge && Voltage_in >= U_Cutoff) //Vorwarnstufe Zwangsabschaltung
	{
		lcd.home();
		lcd.print("U Batt.: ");
		lcd.print(Voltage_in,1); //Wert nur mit einer Nachkommastelle ausgeben -> ,1 anhaengen
		lcd.print(" V");
		lcd.setCursor(0, 1);
		lcd.print("Charge Battery!  ");
    digitalWrite(Pin_charge_led, HIGH);
    status_Pin_charge_led = 1;
    while (midwarningcounter < 8) {
    midwarning();
    }
				
	}
	
	// ---------------------------------------------------------------------- Pruefen ob Spannung die Abschaltspannung unterschritten hat - Lasttrennung nach 60 Sekunden
	if (Voltage_in < U_Cutoff)
	{	
		//cofwarning();		
		timer = 30;
		
		while(Voltage_in < U_Cutoff && timer >0) // ------------------------- Besteht Unterspannung laenger als 30 Sekunden ?
		{
			countdownwarning();
			lcd.home();
			lcd.print("Disconnect Load ");
			lcd.setCursor(0, 1);
			lcd.print("in ");
			lcd.print(timer);
			lcd.print(" Seconds        ");
			delay(1000);
		
			read_voltage_level();
				
			timer--;
		}
		
				
		while (Voltage_in < U_Cutoff) // ---------------------------------- Unterspannung nach 60 Sekunden noch immer vorhanden? - Dann Last abschalten!
		{
			// Betrifft Schalten von T2
      // digitalWrite(Pin_relais, LOW);
			 if (status_bistabrelais_2 == 0)  {
      digitalWrite(Pin_bistabrelais_2, HIGH);
      delay(1000);
      digitalWrite(Pin_bistabrelais_2, LOW);
      status_bistabrelais_2 = 1;
      status_bistabrelais_1 = 0;
    }

			lcd.home();
			lcd.print("U Batt.: ");
			lcd.print(Voltage_in,1); //Wert nur mit einer Nachkommastelle ausgeben -> ,1 anh?ngen
			lcd.print(" V ");
			lcd.setCursor(0, 1);
			lcd.print(" No Load active ");
			delay(1000);
		
			read_voltage_level();
		}
		
	} 
	
		
	delay(1000);
	}

// ***************************************************** ab hier Funktionen ****************************************************

//Auslesen des aktuellen Spannungslevels
void read_voltage_level() {

	Voltage_raw = analogRead(Pin_U_batt);
	Voltage_R2 = ((Voltage_raw * Uref)/1024); //Spannung an R7 des Spannungsteilers berechnen - betr. Uref siehe wichtige Anmerkung
	Voltage_in = Voltage_R2 * 6; //Die 6 ist das Teilerverhaeltnis und muss einbezogen werden, da die obige Formel nur die Spannung am A0 misst
							     //dass ist aber nur die Teilspannung am Teiler. Wir haben 10 k und 49,9 k = 59,9k rges. / R2 (10 k) = 6
	//Serial.println(Voltage_raw);
	//Serial.println(Uref);
	//Serial.println(Voltage_in);
	
}


void Voltage_Settings() { // -------------------------------------------------------- Aufruf des Menues zur Auswahl der Schwellwerte
	
	
	while (status_set_Taster == LOW)
	{
	
		
	status_set_Taster = digitalRead(set_Taster);
	if (status_set_Taster == LOW)
	{
	lcd.home();
	lcd.print("Set             ");
	lcd.setCursor(0, 1);
	lcd.print("Over-Voltage    ");
	set_menu = 1;
	delay(1000);}
	
	status_set_Taster = digitalRead(set_Taster);	
	if (status_set_Taster == LOW)
	{
	lcd.home();
	lcd.print("Set             ");
	lcd.setCursor(0, 1);
	lcd.print("Norm-Voltage    ");
	set_menu = 2;
	delay(1000);
	}
	
	status_set_Taster = digitalRead(set_Taster);
	if (status_set_Taster == LOW)
	{
	lcd.home();
	lcd.print("Set             ");
	lcd.setCursor(0, 1);
	lcd.print("Charge-Voltage  ");
	set_menu = 3;
	delay(1000);
	}
	
	status_set_Taster = digitalRead(set_Taster);
	if (status_set_Taster == LOW)
	{
	lcd.home();
	lcd.print("Set             ");
	lcd.setCursor(0, 1);
	lcd.print("Cut-Off-Voltage ");
	set_menu = 4;
	delay(1000);
	}
	
	
  /*
  status_set_Taster = digitalRead(set_Taster);
	if (status_set_Taster == LOW)
	{
		lcd.home();
		lcd.print("Set             ");
		lcd.setCursor(0, 1);
		lcd.print("  Ref.-Voltage  ");
		set_menu = 5;
	delay(1000);}
	*/
	
  status_set_Taster = digitalRead(set_Taster);
	if (status_set_Taster == LOW)
	{
		lcd.home();
		lcd.print("     Reset      ");
		lcd.setCursor(0, 1);
		lcd.print("    Settings    ");
		set_menu = 6;
	delay(2000);}
	
	
}	
	switch (set_menu)
	{
	case 1:
		learn_Over_voltage();
		break;
	
	case 2:
		learn_Norm_voltage();
		break;	
		
	case 3:
		learn_Charge_voltage();
		break;
		
	case 4:
		learn_Cut_Off_voltage();
		break;	
	
	
  case 5:
		learn_aref_voltage();
		break;
	
	
  case 6:
		learn_reset_voltage();
		break;
	
		
	default:
	
	break;	
			
	}
	
}


void learn_Over_voltage() {
	
	lcd.home(); 
	lcd.print("To adjust Volt  ");
	lcd.setCursor(0, 1);
	lcd.print("Press Button    ");
	delay(2000);
	
	status_set_Taster = digitalRead(set_Taster);
		while(status_set_Taster == LOW) {
			adjust_voltage();
			status_set_Taster = digitalRead(set_Taster);
			U_Overvolt = Voltage_in;
			EEPROM.put(mem_addr_overvolt, U_Overvolt);
		}
	
	
	lcd.home(); //Kontrollausgabe am Ende der Justierung
	lcd.print("  Over-Voltage  ");
	lcd.setCursor(0, 1);
	lcd.print(" set to ");
	lcd.print(U_Overvolt,1);
	lcd.print(" V    ");
	delay(3000);
}

void learn_Norm_voltage() {
	
	lcd.home();
	lcd.print("To adjust Volt  ");
	lcd.setCursor(0, 1);
	lcd.print("Press Button    ");
	delay(2000);
	
	status_set_Taster = digitalRead(set_Taster);
	while(status_set_Taster == LOW) {
		adjust_voltage();
		status_set_Taster = digitalRead(set_Taster);
		U_Norm = Voltage_in;
		EEPROM.put(mem_addr_normvolt, U_Norm);
				
	}
		lcd.home(); //Kontrollausgabe am Ende der Justierung
		lcd.print("  Norm-Voltage  ");
		lcd.setCursor(0, 1);
		lcd.print(" set to ");
		lcd.print(U_Norm,1);
		lcd.print(" V    ");
		delay(3000);
	
}


void learn_Charge_voltage() {
	
	lcd.home();
	lcd.print("To adjust Volt  ");
	lcd.setCursor(0, 1);
	lcd.print("Press Button    ");
	delay(2000);
	
	status_set_Taster = digitalRead(set_Taster);
	while(status_set_Taster == LOW) {
		adjust_voltage();
		status_set_Taster = digitalRead(set_Taster);
		U_Charge = Voltage_in;
		EEPROM.put(mem_addr_chargevolt, U_Charge);
	}
	
	lcd.home(); //Kontrollausgabe am Ende der Justierung
	lcd.print(" Charge-Voltage ");
	lcd.setCursor(0, 1);
	lcd.print(" set to ");
	lcd.print(U_Charge,1);
	lcd.print(" V    ");
	delay(3000);
	
}

void learn_Cut_Off_voltage() {
	
	lcd.home();
	lcd.print("To adjust Volt  ");
	lcd.setCursor(0, 1);
	lcd.print("Press Button    ");
	delay(2000);
	
	status_set_Taster = digitalRead(set_Taster);
	while(status_set_Taster == LOW) {
		adjust_voltage();
		status_set_Taster = digitalRead(set_Taster);
		U_Cutoff = Voltage_in;
		EEPROM.put(mem_addr_cutoffvolt, U_Cutoff);
	}
		
	lcd.home(); //Kontrollausgabe am Ende der Justierung
	lcd.print("Cut-Off-Voltage ");
	lcd.setCursor(0, 1);
	lcd.print(" set to ");
	lcd.print(U_Cutoff,1);
	lcd.print(" V    ");
	delay(3000);
	
}

void learn_aref_voltage() {
			
	lcd.home();
	lcd.print("To adjust Aref  ");
	lcd.setCursor(0, 1);
	lcd.print("Press Button    ");
	delay(2000);
	
	status_set_Taster = digitalRead(set_Taster);
	while(status_set_Taster == LOW) {
		adjust_aref_voltage();
		status_set_Taster = digitalRead(set_Taster);
	}
	
		
	
	
	lcd.home(); //Kontrollausgabe am Ende der Justierung
	lcd.print("Ref.-Voltage    ");
	lcd.setCursor(0, 1);
	lcd.print(" set to ");
	lcd.print(Uref);
	lcd.print(" V    ");
	delay(3000);
	}


void adjust_voltage() {
	
	Voltage_raw = analogRead(PIN_U_batt2);
	Voltage_R2 = ((Voltage_raw * Uref)/1024); //Spannung an R2 des Spannungsteilers berechnen 
	Voltage_in = Voltage_R2 * 6;
	lcd.home();
	lcd.print("Adjusting ");
	lcd.print(Voltage_in,1);
	lcd.print(" V");
	lcd.setCursor(0, 1);
	lcd.print(" Release Button ");
	delay(400);
	lcd.setCursor(0, 1);
	lcd.print("     if OK      ");
	delay(400);
	
}

void adjust_aref_voltage() {
	
	Voltage_raw = analogRead(PIN_U_batt2);
	Voltage_R2 = ((Voltage_raw * Uref)/1024); //Spannung an R2 des Spannungsteilers berechnen 
	Voltage_aref_in = Voltage_R2 * 6;
	
	
	if (Voltage_aref_in > 5) {    //Begrenzt den oberen Wert für die Anzeige im LCD als auch für die Uebergabe an Uref auf 5 V
		int voltage_diff;
		int voltage_diff_result;
		voltage_diff = Voltage_aref_in - 5;
		voltage_diff_result = Voltage_aref_in - voltage_diff;
		Voltage_aref_in = voltage_diff_result;
		}	//Ende der Begrenzung auf 5V
	
	
	lcd.home();
	lcd.print("Adjusting ");
	lcd.print(Voltage_aref_in);
	lcd.print(" V");
	lcd.setCursor(0, 1);
	lcd.print(" Release Button ");
	delay(400);
	lcd.setCursor(0, 1);
	lcd.print("     if OK      ");
	delay(400);
}



void learn_reset_voltage() { //EEPROM-Werte auf Default zuruecksetzen - z.B. bei falscher Programmierung
	
	lcd.home();
	lcd.print(" Reset Settings ");
	lcd.setCursor(0, 1);
	lcd.print("    . . . .     ");
	delay(400);
			
	// Festlegen der Default-Werte
  EEPROM.put(mem_addr_overvolt, 13.9);
	EEPROM.put(mem_addr_normvolt, 12.0);
	EEPROM.put(mem_addr_chargevolt, 11.2);
	EEPROM.put(mem_addr_cutoffvolt, 10.7);
	EEPROM.put(mem_addr_Uref, 5.02); // Standard: 5
	
	lcd.home();
	lcd.print(" Set to Default ");
	lcd.setCursor(0, 1);
	lcd.print("Rebooting now...");
	delay(1000);
	
   do_Reset();	//Fuehre einen Software-Reset aus
}


void do_Reset() // Startet das Programm von Anfang an setzt aber nicht die Register zurueck
{
	asm volatile ("jmp 0");
}


void prewarning() {
  digitalWrite(Pin_buzzer, HIGH);
  delay(1000);
  digitalWrite(Pin_buzzer, LOW);
  delay(1000);
}


void midwarning() {
 	  digitalWrite(Pin_buzzer, HIGH);
	  delay(1000);
	  digitalWrite(Pin_buzzer, LOW);
	  delay(1000);
    midwarningcounter++;
}


void cofwarning() {
	digitalWrite(Pin_buzzer, HIGH);
	delay(100);
	digitalWrite(Pin_buzzer, LOW);
	delay(100);
  cofwarningcounter++;
	}

void countdownwarning() {
	digitalWrite(Pin_buzzer, HIGH);
	delay(100);
	digitalWrite(Pin_buzzer, LOW);
	
}
