import ddf.minim.*;
import ddf.minim.spi.AudioStream;

float MHz=1e6 ;
float kHz=1e3 ;

float Ohm=1 ;
float mW=1e-3 ;
float pi=PI ;
float twopi=2.0*pi ;

float RXfrq=77500-5.5-0.5 ;
//float RXfrq=60000-5.5 ;
float xyGain=120 ;
//float gain=0.05 ; // DCF
float RXgain=0.01 ; 

float fg1=500 ;
float fg2=10 ;


float LOdeltaPhase=0 ;
float LOphase=0 ;

int scopeSigChn=0 ;
int scopeInpChn=0 ;
int scopeIIchn=0 ;
int scopeQQchn=0 ;
int scopeAmplChn=0 ;
int scopePhaseChn=0 ;
XYscope1 xyScope=new XYscope1("myScope",400,400) ;

int nPoints=8192 ;
int streamBufferSize=32768 ;
float fSample1=192000.0 ;
float tSample1=1.0/fSample1 ;
float carrierSampleFrequency=fSample1 ;
int nDown1=40 ;
float fSample2=fSample1/nDown1 ;
int nDown2=32 ;
float fSample3=fSample2/nDown2 ;

int displaySizeX=900 ;
int displaySizeY=700 ;
int yMidth=300 ;

LpIIRfilter1 inpBandpass=new LpIIRfilter1() ;

LpIIRfilter1 IIlowpass1=new LpIIRfilter1() ;
LpIIRfilter1 QQlowpass1=new LpIIRfilter1() ;

LpIIRfilter1 IIlowpass2=new LpIIRfilter1() ;
LpIIRfilter1 QQlowpass2=new LpIIRfilter1() ;

Minim minim;
AudioStream input ;
MultiChannelBuffer buffer; 
int getPtr=Integer.MAX_VALUE ;
float sample=0 ;
float inpBuf[]=new float[nPoints] ;
float rms1=0 ;
float rms1Show ;

//---------------------------------------------------------------------------------------  
  
void readInpBuf(){
  rms1=0 ;
  getPtr=Integer.MAX_VALUE ;
  for(int k=0 ; k<nPoints ; k++){ 
    if(getPtr>=buffer.getBufferSize()){ 
      getPtr=0 ;
      input.read(buffer) ;
      }
    sample=RXgain*buffer.getSample(0,getPtr) ;
    getPtr++ ;
    inpBuf[k]=sample ;
    rms1+=sqr(sample) ;
    }
  rms1Show=sqrt(rms1/nPoints) ;
  }

float IIsig0=0 ;
float QQsig0=0 ;

float IIsig1=0 ;
float QQsig1=0 ;

float IIsig2=0 ;
float QQsig2=0 ;

float signal ;
float inpSignal=0 ;

int downCount1=0 ;
int downCount2=0 ;
float amplitude=0 ;
float phase=0 ;

void mixInpBuf(){
  for (int xk=0 ; xk<nPoints ; xk++) {
    inpSignal=inpBuf[xk] ;
    signal=inpBandpass.run(inpSignal) ;
    LOphase += LOdeltaPhase ;
    if(LOphase>twopi){ LOphase -= twopi ; }
    IIsig0=signal*cos( LOphase ) ;
    QQsig0=signal*sin( LOphase ) ;
    IIsig1=IIlowpass1.run(IIsig0) ;
    QQsig1=QQlowpass1.run(QQsig0) ;
    downCount1++ ;
    if(downCount1>=nDown1){
      downCount1=0 ;
      IIsig2=IIlowpass2.run(IIsig1) ;
      QQsig2=QQlowpass2.run(QQsig1) ;
      downCount2++ ;
      if(downCount2>=nDown2){
        downCount2=0 ;
        amplitude=sqrt(sqr(IIsig2)+sqr(QQsig2)) ;  
        phase=atan2(IIsig2,QQsig2) ;
        decode() ;
        }
      }
    }
  }      
  
void decode(){
  scopeDrawY(scopeSigChn, signal) ;
  scopeDrawY(scopeInpChn, inpSignal*500) ;
  scopeDrawY(scopeIIchn, IIsig2) ;
  scopeDrawY(scopeQQchn, QQsig2) ;
  scopeDrawY(scopeAmplChn, amplitude) ;
  scopeDrawY( scopePhaseChn, phase) ;
  scopeAdvance() ;
  xyScope.put(IIsig2,QQsig2) ;  
  }
  
void draw(){
  readInpBuf() ;
  mixInpBuf() ;
  }
  
void settings(){
  size(displaySizeX, displaySizeY);
  }
   
void setup(){
  println() ;
  println("PCasSDRfrontendDemo1V02()...") ;
    
  PFont font = createFont("Monospaced.bold", 20);
  textFont(font);
  strokeWeight(2) ;
  scopeInpChn=getChannel(50,10.0, color(255,0,0),true ,"Inp") ;
  scopeSigChn=getChannel(120,10.0, color(255,0,0),true ,"Sig") ;
  scopeIIchn=getChannel(250,30.0, color(255,0,255),true ,"II" ) ;
  scopeQQchn=getChannel(350,30.0, color(255,0,255),true , "QQ") ;
  scopeAmplChn=getChannel(500,-50.0, color(255,255,0),true, "Ampl" ) ;
  scopePhaseChn=getChannel(600,25.0, color(255,255,0),true , "Phase") ;
    
  xyScope.setup() ;
  
  LOphase=0 ;
  LOdeltaPhase=(RXfrq/fSample1*twopi) ;
  
  minim = new Minim(this);
  fill(0,0,0) ;
  //inpBandpass.bandpass(RXfrq/fSample1,0.99) ;
  inpBandpass.bandpass(RXfrq/fSample1,0.9995) ;
 
  IIlowpass1.butter(4,fg1/fSample1 ) ;
  QQlowpass1.butter(4,fg1/fSample1 ) ;
  
  IIlowpass2.butter(4,fg2/fSample2 ) ;
  QQlowpass2.butter(4,fg2/fSample2 ) ;
  
  //IIlowpass2.butter(4,4/fSample2 ) ;
  //QQlowpass2.butter(4,4/fSample2 ) ;
  
  
  input=minim.getInputStream(Minim.STEREO,streamBufferSize,(float)fSample1,16) ; // 
  input.open() ;
  buffer= new MultiChannelBuffer(1024, input.getFormat().getChannels());
  println("buffer.getChannelCount()="+buffer.getChannelCount()) ;
  println("buffer.getBufferSize()="+buffer.getBufferSize() ) ;
  println(String.format("fSample1=%15.3f Hz",fSample1)) ;
  println(String.format("fSample2=%15.3f Hz",fSample2)) ;
  println(String.format("fSample3=%15.3f Hz",fSample3)) ;
  
  clear() ;
  }
  
  
  
  
  
  
  
  
