import ddf.minim.*;
import ddf.minim.spi.AudioStream;

float MHz=1e6 ;
float kHz=1e3 ;
float Ohm=1 ;
float mW=1e-3 ;
float pi=PI ;
float twopi=2.0*pi ;

float RXfrq=60000-4 ;
float RXgain=0.1 ;
float xyGain=0.001 ;

float LOdeltaPhase=0 ;
float LOphase=0 ;

int nPoints=8192 ;
int streamBufferSize=32768 ;
float fSample1=192000.0 ;
float tSample1=1.0/fSample1 ;
float carrierSampleFrequency=fSample1 ;

//int nDown1=80 ;
int nDown1=86 ;
int down1Count=0 ;
float fSample2=fSample1/nDown1 ;
float tSample2=1.0/fSample2 ;
float fg1=50 ;
float fg2=5 ;

boolean withShow=true ;

float fSample3=100 ;
float tSample3=1.0/fSample3 ;
float RXsampleTimer=0 ;

volatile int secondTimer=0 ;

LpIIRfilter1 inpBandpass=new LpIIRfilter1() ;
LpIIRfilter1 IIlowpass1=new LpIIRfilter1() ;
LpIIRfilter1 QQlowpass1=new LpIIRfilter1() ;
LpIIRfilter1 IIlowpass2=new LpIIRfilter1() ;
LpIIRfilter1 QQlowpass2=new LpIIRfilter1() ;
LpIIRfilter1 demodFil=new LpIIRfilter1() ;

Minim minim;
AudioStream input ;
MultiChannelBuffer buffer; 
int iGet=Integer.MAX_VALUE ;

float sample=0 ;

float inpBuf[]=new float[nPoints] ;

int xMin=0 ; int xMax=nPoints ;

float yMin=-100 ;
float yMax= 100 ;

int displaySizeX=900 ;
int displaySizeY=700 ;
  
//---------------------------------------------------------------------------------------  
int scopeSigChn=0 ;
int scopeInpChn=0 ;
int scopeIIchn=0 ;
int scopeQQchn=0 ;
int scopeAmplChn=0 ;
int scopePhaseChn=0 ;
int scopeTimerChn=0 ;
int scopeThresholdChn=0 ;
int scopeDemodChn=0 ;
 
int nn=0 ;  
float rms1=0 ;
float rms1show ;

void readInputBuffer(){
  rms1=0 ;
  iGet=Integer.MAX_VALUE ;
  for(int k=0 ; k<nPoints ; k++){ 
    if(iGet>=buffer.getBufferSize()){ 
      iGet=0 ;
      input.read(buffer) ;
      }
    sample=RXgain*buffer.getSample(0,iGet) ;
    iGet++ ;
    inpBuf[k]=sample ;
    rms1+=sqr(sample) ;
    }
  rms1show=sqrt(rms1/nPoints) ;
  }

float IIsum=0 ;
float QQsum=0 ;
float II=0 ;
float QQ=0 ;

float IIsig0=0 ;
float QQsig0=0 ;

float IIsig1=0 ;
float QQsig1=0 ;

float IIsig2=0 ;
float QQsig2=0 ;

float signal ;
float inpSignal=0 ;

int downCount1=0 ;
int downCount2=0 ;
float amplitude=0 ;
float phase=0 ;

void mixInpBuf(){
  for (int xk=0 ; xk<nPoints ; xk++) {
    inpSignal=inpBuf[xk] ;
    signal=inpBandpass.run(inpSignal) ;
    IIsig0=signal*cos( LOphase ) ;
    QQsig0=signal*sin( LOphase ) ;
    IIsig1=IIlowpass1.run(IIsig0) ;
    QQsig1=QQlowpass1.run(QQsig0) ;
    LOphase += LOdeltaPhase ;
    if(LOphase>twopi){ LOphase -= twopi ; }
     down1Count++ ;
    if(down1Count>=nDown1) {
      down1Count=0 ;
      down2() ;
      }
    }
  }      
  
float inputVal=0 ;
float ampl,ampl1 ;
float AMthreshold=200 ;

int Duration ;
int sigValue=0 ;
int lastSigValue=0 ;
int Second=0 ;

void down2(){
  IIsig2=IIlowpass2.run(IIsig1) ;
  QQsig2=QQlowpass2.run(QQsig1) ;
  RXsampleTimer+=tSample2 ;
  if(RXsampleTimer>tSample3){
    RXsampleTimer-=tSample3 ;
    ampl1=100*log(sqrt(IIsig2*IIsig2+QQsig2*QQsig2)) ;
    ampl=(float)demodFil.run(ampl1) ;
    msfSample() ;
    color ca ;  
    ca=color(255,255,255) ;
    float ampl2=ampl ;
    float bb=50 ;
    if(ampl2<bb){ ampl2=bb ; }
    float phase=-10*atan2(IIsig2,QQsig2) ;
    scopeDrawY(scopeInpChn, inpSignal) ;
    scopeDrawY(scopeSigChn, signal ) ;
    scopeDrawY(scopeIIchn, IIsig2) ;
    scopeDrawY(scopeQQchn, QQsig2) ;
    scopeDrawY(scopeAmplChn, ampl2) ;
    scopeDrawY(scopeThresholdChn, AMthreshold) ;
    scopeDrawY( scopePhaseChn, phase) ;
    scopeDrawY( scopeTimerChn, debug1) ;
    scopeDrawY( scopeDemodChn,sigValue) ;
    scopeAdvance() ;      
    xyScope.put(xyGain*IIsig2,xyGain*QQsig2) ; 
    }
 }
    
void draw(){
  readInputBuffer() ;
  mixInpBuf() ;
  }
  
void settings(){
  size(displaySizeX,displaySizeY, P3D);
  }

scopeClock scopeClock1=new scopeClock("myClock",500,500) ;
XYscope1 xyScope=new XYscope1("myScope",400,400) ;

void setup(){
  minim = new Minim(this);
  PFont font;
  font = createFont("Monospaced.bold", 20);
  textFont(font);
  xyScope.setup() ;
  scopeClock1.setup() ;
  fill(0,0,0) ;
  
  scopeInpChn=getChannel(60,5e2, color(255,0,0),true ,"Inp") ;
  scopeSigChn=getChannel(120,0.6, color(255,0,0),true ,"Sig") ;
  
  scopeIIchn=getChannel(180,1, color(255,0,255),true ,"II" ) ;
  scopeQQchn=getChannel(230,1, color(255,0,255),true , "QQ") ;
  
  scopeAmplChn=getChannel(460,-0.5, color(255,255,0),true, "Ampl" ) ;
  scopeThresholdChn=getChannel(460,-0.5, color(0,255,255),true, "" ) ;

  scopeTimerChn=getChannel(520,-0.5, color(255,255,0),true , "Timer") ;
  scopeDemodChn=getChannel(570,-10, color(255,255,0),true , "demod") ;
  
  scopePhaseChn=getChannel(650,1, color(255,255,0),true , "Phase") ;
    
  inpBandpass.bandpass(RXfrq/fSample1,0.9998) ;
  
  IIlowpass1.butter(4,fg1/fSample1 ) ;
  QQlowpass1.butter(4,fg1/fSample1 ) ;
  
  IIlowpass2.butter(4,fg2/fSample2 ) ;
  QQlowpass2.butter(4,fg2/fSample2 ) ;
  
  LOphase=0 ;
  LOdeltaPhase=(RXfrq/fSample1*twopi) ;

  demodFil.butter(4,4.0/fSample3) ;
  println(String.format("fSample1  = %12.2f ",fSample1)) ;
  println(String.format("fSample2 = %12.2f ",fSample2)) ;
  println(String.format("fSample3  = %12.2f ",fSample3)) ;
  input=minim.getInputStream(Minim.STEREO,streamBufferSize,(float)fSample1,16) ; // 
  input.open() ;
  buffer= new MultiChannelBuffer(1024, input.getFormat().getChannels());
  println("buffer.getChannelCount()="+buffer.getChannelCount()) ;
  println("buffer.getBufferSize()="+buffer.getBufferSize() ) ;
  clear() ;
  }
  

  
  
  
  
  
