double linMap(double x1, double x2, double y1, double y2, double x) {
  return(y1+(x-x1)/(x2-x1)*(y2-y1)) ;
  }
  
void dottedLine(int x0, int y0, int x1, int y1){
  double length=Math.sqrt(sqr(x1-x0)+sqr(y1-y0)) ;
  int nSegments=(int)(length/20.0) ;
  for(int k=0 ; k<nSegments ; k++){
    int xA=(int)linMap((double)0,(double)nSegments,(double)x0,(double)x1,k) ;
    int yA=(int)linMap((double)0,(double)nSegments,(double)y0,(double)y1,k) ;
    int xB=(int)linMap((double)0,(double)nSegments,(double)x0,(double)x1,k+0.2) ;
    int yB=(int)linMap((double)0,(double)nSegments,(double)y0,(double)y1,k+0.2) ;
    line(xA,yA,xB,yB) ;
    }
  }

float sqr(float x){ return x*x ; } 

float log10(float x) { return log(x)/log(10) ; }

float linMap(float x1, float x2, float y1, float y2, float x) {
  return(y1+(x-x1)/(x2-x1)*(y2-y1)) ;
  }

void abort(){
  println("abort() !") ;
  println("System.exit(0)") ;
  System.exit(0) ;
  }
    
void idle(){
  println("idle()...") ;
  while(true){} 
  }

int parity(int from , int to) {
  int parity ;
  int k ;
  parity=0 ;
  for (k=from ; k<=to ; k++){
    parity ^=  MSFbits[k] ;
    }
  parity &= 1 ;
  return parity ;
  }

void parityCheck(int from , int to , int checkPosition) {
  int p ;
  p=parity(from,to) ;
  if ( (MSFbits[checkPosition] & 2 ) !=0) {
    p ^= 1 ;
    }
  outPutc(' ') ; outPutc('P') ; outPutc('=') ;
  outPutc('0'+p) ;
  }
  
void outPutc(char c){ print(c) ; }
void outPutc(int d){ print((char)d) ; }

void OutBCD2(int v){
  outPutc('0'+(v>>4)) ;
  outPutc('0'+(v & 0xf)) ;
  }
  
int getBCD2(int v){
  int d=10*((v>>4) & 0xf) ;
  d +=(v & 0xf) ;
  return d ;
  }  

void outBlank(){
  outPutc(' ') ; 
  }
  
