double us=1e-6 ;
double ms=1e-3 ;
double MHz=1e6 ;
double kHz=1e3 ;
double mH=1e-3 ;
double uH=1e-6 ;
double pF=1e-12 ;
double nF=1e-9 ;
double uF=1e-6 ;

double sqr(double x){
  return x*x ;
  }
  
double sysClk=125*MHz ;

void fracDivSim1V01(){
  println("fracDivSim1V01") ;
  int CLKDIVint=3 ;
  int CLKDIVfrac=256/7 ;
  
  int nSim=1000000000 ;
  println(String.format("nSim=%08XH\n",nSim)) ;
  int CLKDIVcnt=0 ;
  int frqCounter=0 ;
  
  int FRACphase=0 ;
  int nPeriod=CLKDIVint ;
  
  for(int k=0 ; k<nSim ; k++){
    if(CLKDIVcnt==0){
      FRACphase+=CLKDIVfrac ;
      nPeriod=CLKDIVint ; 
      if(FRACphase>255){ nPeriod++ ; } 
      FRACphase=FRACphase & 0xFF ;
      frqCounter++ ;
      }
    CLKDIVcnt++ ;
    if(CLKDIVcnt==nPeriod){ CLKDIVcnt=0 ; }
    }
  println("frqCounter=",frqCounter) ; 
  double ratio1=((double)nSim)/frqCounter ;
  println("frqCounter/nSim=",ratio1," ratio") ;
  double ratio2=CLKDIVint+CLKDIVfrac/256.0 ;
  println("CLKDIVint+CLKDIVfrac/256.0=",ratio2) ;
  println("rel Error=",(ratio2-ratio1)/ratio2) ;
  println("frq=",sysClk*frqCounter/nSim/MHz," MHz") ;
  }
  
void setup(){
  double fCPU=100*MHz ;
  long CLKDIV_INT=3 ;
  long CLKDIV_FRAC=(int)(256.0/3.0+0.5) ;
  double fOut=fCPU / (CLKDIV_INT + CLKDIV_FRAC / 256.0) / 2.0 ;
  println("fOut=",fOut) ;
  println() ;
  fracDivSim1V01() ;
  
  }
  
