#include <stdio.h>
 #include <string.h>
 #include <math.h>
 #include <time.h>
 #include "pico/stdlib.h"
 //#include "pico/multicore.h"
 #include "hardware/gpio.h"
 #include "pico/binary_info.h"
 //#include "hardware/irq.h" 
 //#include "hardware/interp.h"
 //#include "pico/divider.h"

#define cpuClkkHz 160000

#define gpio4 4
#define gpio5 5

void abort(){
  printf("\nAbort()....Idle()....\n") ;
  while(1){}
  }  

#include "measureTimeWithPWM.c" 

int ix,iy,iz ;
float fx,fy,fz ;
int result[100] ;

void intAdd(){
  printf("intAdd\n") ;
  ix=1234567 ;
  iy=7654321 ;
  PWMmeasure1Init  
  for(int m=0 ; m<logStop ; m++){
    PWMmeasure1Start
    iz=ix+iy ;
    PWMmeasure1Stop
    }
  PWMmeasure1Show
  printf("ix=%d iy=%d  ",ix,iy) ;
  printf("result iz=%d\n",iz) ;
  }

void intMul(){
  printf("intMul\n") ;
  ix=1234 ;
  iy=7654 ;
  PWMmeasure1Init  
  for(int m=0 ; m<logStop ; m++){
    PWMmeasure1Start
    asm volatile("intMulLabel1:");
    iz=ix*iy ;
    asm volatile("intMulLabel2:");
    PWMmeasure1Stop
    }
  PWMmeasure1Show
  printf("ix=%d iy=%d  ",ix,iy) ;
  printf("result iz=%d\n",iz) ;
  }

void intMul2(){
  int ix,iy,iz ;
  printf("intMul2\n") ;
  ix=123 ;
  iy=24 ;
  PWMmeasure1Init  
  for(int m=0 ; m<logStop ; m++){
    PWMmeasure1Start
    asm volatile("intMul2Label1:");
    iz=ix*iy ;
    asm volatile("intMul2Label2:");
    PWMmeasure1Stop
    ix++ ;
    result[m]=iz ;
    }
  for(int m=0 ; m<logStop ; m++){
    printf("result[%d]=%08XH\n",m,result[m]) ;
    }
  PWMmeasure1Show
  printf("ix=%d iy=%d  ",ix,iy) ;
  printf("result iz=%d\n",iz) ;
  }  






void intDiv(){
  printf("intDiv\n") ;
  ix=12345678 ;
  iy=5678 ;
  PWMmeasure1Init  
  for(int m=0 ; m<logStop ; m++){
    PWMmeasure1Start
    asm volatile("intDivLabel1:");
    iz=ix/iy ;
    asm volatile("intDivLabel2:");
    PWMmeasure1Stop
    }
  PWMmeasure1Show
  printf("ix=%d iy=%d  ",ix,iy) ;
  printf("result iz=%d\n",iz) ;
  }

void intDiv2(){
  int ix,iy,iz ;
  printf("intDiv2\n") ;
  ix=12345678 ;
  iy=23456 ;
  PWMmeasure1Init  
  for(int m=0 ; m<logStop ; m++){
    PWMmeasure1Start
    asm volatile("intDiv2Label1:");
    iz=ix/iy ;
    asm volatile("intDiv2Label2:");
    PWMmeasure1Stop
    ix++ ;
    result[m]=iz ;
    }
  for(int m=0 ; m<logStop ; m++){
    printf("result[%d]=%08XH\n",m,result[m]) ;
    }
  PWMmeasure1Show
  printf("ix=%d iy=%d  ",ix,iy) ;
  printf("result iz=%d\n",iz) ;
  }  



void intShift(){
  printf("intShift\n") ;
  ix=123 ;
  iy=24 ;
  PWMmeasure1Init  
  for(int m=0 ; m<logStop ; m++){
    PWMmeasure1Start
    asm volatile("intShiftLabel1:");
    iz=ix<<iy ;
    asm volatile("intShiftLabel2:");
    PWMmeasure1Stop
    ix++ ;
    result[m]=iz ;
    }
  for(int m=0 ; m<logStop ; m++){
    printf("result[%d]=%08XH\n",m,result[m]) ;
    }
  PWMmeasure1Show
  printf("ix=%d iy=%d  ",ix,iy) ;
  printf("result iz=%d\n",iz) ;
  }  

void intShift2(){
  int ix,iy,iz ;
  printf("intShift2\n") ;
  ix=123 ;
  iy=24 ;
  PWMmeasure1Init  
  for(int m=0 ; m<logStop ; m++){
    PWMmeasure1Start
    asm volatile("intShift2Label1:");
    iz=ix<<iy ;
    asm volatile("intShift2Label2:");
    PWMmeasure1Stop
    ix++ ;
    result[m]=iz ;
    }
  for(int m=0 ; m<logStop ; m++){
    printf("result[%d]=%08XH\n",m,result[m]) ;
    }
  PWMmeasure1Show
  printf("ix=%d iy=%d  ",ix,iy) ;
  printf("result iz=%d\n",iz) ;
  }  

void floatAdd(){
  printf("floatAdd\n") ;
  fx=1234567 ;
  fy=7654321 ;
  PWMmeasure1Init  
  for(int m=0 ; m<logStop ; m++){
    PWMmeasure1Start
    fz=fx+fy ;
    PWMmeasure1Stop
    }
  PWMmeasure1Show
  printf("fx=%10.3f fy=%10.3f  ",fx,fy) ;
  printf("result fz=%10.3f\n",fz) ;
  }

void floatMul(){
  printf("floatMul\n") ;
  fx=1234567 ;
  fy=7654321 ;
  PWMmeasure1Init  
  for(int m=0 ; m<logStop ; m++){
    PWMmeasure1Start
    fz=fx*fy ;
    PWMmeasure1Stop
    }
  PWMmeasure1Show
  printf("fx=%10.3f fy=%10.3f  ",fx,fy) ;
  printf("result fz=%10.3f\n",fz) ;
  }

void floatDiv(){
  printf("floatDiv\n") ;
  fx=1234567 ;
  fy=7654321 ;
  PWMmeasure1Init  
  for(int m=0 ; m<logStop ; m++){
    PWMmeasure1Start
    fz=fx/fy ;
    PWMmeasure1Stop
    }
  PWMmeasure1Show
  printf("fx=%10.3f fy=%10.3f  ",fx,fy) ;
  printf("result fz=%10.3f\n",fz) ;
  }

int main() {
  set_sys_clock_khz(cpuClkkHz, true);
  stdio_init_all();
  gpio_init(gpio4);
  gpio_set_dir(gpio4, GPIO_OUT);

  gpio_init(gpio5);
  gpio_set_dir(gpio5, GPIO_OUT);


  printf("\n\n\n*****************************************************************\n") ;
    printf("picoHardwareDivider1V01\n") ;
    main2() ;
  //divideTest1() ;
  //HWdividerTest1() ;
  //asmDelay1testRun(100) ;

 // intAdd() ; // @160MHz 0.08 us
//  intMul() ; // @160MHz 0.08 us
//  intMul2() ; //
 intDiv() ; // @160MHz 0.21 us
 intDiv2() ; //
// intShift() ; // @160MHz 0.08 us
// intShift2() ; // @160MHz 0.08 us

 //floatAdd() ; // @160MHz 0.54 us
 // floatMul() ; // @160MHz 0.51 us
 //  floatDiv() ; // @160MHz 0.62 us

  //doToggle() ; // at 16MHz 2.5us per loop = 4 cycles
  //int32Add() ; // at 16MHz 1.8 us pico @160MHz 0.08 us, 1.8us/0.08us=22
  //int32Mul() ; // at 16MHz 6.1 us pico @160MHz 0.08 us 6.1us/0.08us=76
  //int32Div() ; // at 16MHz 39.8 us pico @160MHz 0.21 us 39.8us/0.21 us=189
  //int32Shift() ; // at 16MHz 12 us pico @160MHz 0.08 us 12us/0.08 us=150

  //floatAdd() ; // at 16MHz 10.4 us pico @160MHz 0.54 us 10.4us/0.54 us=19
  //floatMul() ; // at 16MHz 9.1 us pico @160MHz 0.51 us 9.1us/0.51 us=18
  //floatDiv() ; // at 16MHz 30 us pico @160MHz 0.62 us 30us/0.62 us=48

  abort() ;
  }
