#include <stdio.h>
#include "pico/stdlib.h"
#include "pico/multicore.h"

static uint32_t configured_freq[20];

#include <stdlib.h>
#include "hardware/pll.h"
#include "hardware/structs/clocks.h"
#include "pico/time.h"
#include "hardware/watchdog.h"
#include "hardware/regs/clocks.h"

#include "hardware/xosc.h"

#include "hardware/clocks.h"
#include "hardware/structs/clocks.h"

//#include "pico/rosc.h"
//#include "C:\abOssmann\pico4Feb2023\Pico\pico-extras\src\rp2_common\hardware_rosc\include\hardware\rosc.h"
//#include "C:\abOssmann\pico4Feb2023\Pico\pico-extras\src\rp2_common\hardware_rosc\rosc.c"
#include "hardware/structs/rosc.h"

inline static void rosc_clear_bad_write(void) {
    hw_clear_bits(&rosc_hw->status, ROSC_STATUS_BADWRITE_BITS);
}

inline static bool rosc_write_okay(void) {
    return !(rosc_hw->status & ROSC_STATUS_BADWRITE_BITS);
}

inline static void rosc_write(io_rw_32 *addr, uint32_t value) {
    rosc_clear_bad_write();
    assert(rosc_write_okay());
    *addr = value;
    assert(rosc_write_okay());
};

void rosc_disable(void) {
    uint32_t tmp = rosc_hw->ctrl;
    tmp &= (~ROSC_CTRL_ENABLE_BITS);
    tmp |= (ROSC_CTRL_ENABLE_VALUE_DISABLE << ROSC_CTRL_ENABLE_LSB);
    rosc_write(&rosc_hw->ctrl, tmp);
    // Wait for stable to go away
    while(rosc_hw->status & ROSC_STATUS_STABLE_BITS);
}


//*************************************************************************

static inline bool has_glitchless_mux(enum clock_index clk_index) {
    return clk_index == clk_sys || clk_index == clk_ref;
}

/// \tag::clock_configure[]
bool clock_configure1(enum clock_index clk_index, uint32_t src, uint32_t auxsrc, uint32_t src_freq, uint32_t freq) {
    uint32_t div;

   printf("clock_configure1()\n") ;
   printf("clk_index= %d\n",clk_index) ;
   printf("src= %d\n",src) ;
   printf("auxsrc= %d\n",auxsrc) ;
   printf("src_freq %d\n",src_freq) ;
   printf("freq %d\n",freq) ;

    assert(src_freq >= freq);

    if (freq > src_freq)
        return false;

    // Div register is 24.8 int.frac divider so multiply by 2^8 (left shift by 8)
    div = (uint32_t) (((uint64_t) src_freq << 8) / freq);
    printf("div>>8=%d\n",div>>8) ;

    clock_hw_t *clock = &clocks_hw->clk[clk_index];

    // If increasing divisor, set divisor before source. Otherwise set source
    // before divisor. This avoids a momentary overspeed when e.g. switching
    // to a faster source and increasing divisor to compensate.
    if (div > clock->div){
        printf("preset clock->div = %08XH\n",div) ;
        clock->div = div;
        }

    // If switching a glitchless slice (ref or sys) to an aux source, switch
    // away from aux *first* to avoid passing glitches when changing aux mux.
    // Assume (!!!) glitchless source 0 is no faster than the aux source.
    
    
    if (has_glitchless_mux(clk_index) && src == CLOCKS_CLK_SYS_CTRL_SRC_VALUE_CLKSRC_CLK_SYS_AUX) {
        printf("Has glitchless mux!\n") ;
        hw_clear_bits(&clock->ctrl, CLOCKS_CLK_REF_CTRL_SRC_BITS);
        while (!(clock->selected & 1u))
            tight_loop_contents();
    }
   


    // If no glitchless mux, cleanly stop the clock to avoid glitches
    // propagating when changing aux mux. Note it would be a really bad idea
    // to do this on one of the glitchless clocks (clk_sys, clk_ref).
    else {
        // Disable clock. On clk_ref and clk_sys this does nothing,
        // all other clocks have the ENABLE bit in the same position.
        printf("no glitchless mux!\n") ;
        hw_clear_bits(&clock->ctrl, CLOCKS_CLK_GPOUT0_CTRL_ENABLE_BITS);

       //  if (1) {
        printf("configured_freq[clk_index]=%d\n",configured_freq[clk_index]) ;
        if (configured_freq[clk_index] > 0) {
            

            // Delay for 3 cycles of the target clock, for ENABLE propagation.
            // Note XOSC_COUNT is not helpful here because XOSC is not
            // necessarily running, nor is timer... so, 3 cycles per loop:


             uint delay_cyc = configured_freq[clk_sys] / configured_freq[clk_index] + 1;
            // uint delay_cyc=5 ;  
            
            
            asm volatile (
                ".syntax unified \n\t"
                "1: \n\t"
                "subs %0, #1 \n\t"
                "bne 1b"
                : "+r" (delay_cyc)
            );
        }
    }

    // Set aux mux first, and then glitchless mux if this clock has one
    printf("set aux mux first auxsrc=%d\n",auxsrc) ;

    hw_write_masked(&clock->ctrl,
        (auxsrc << CLOCKS_CLK_SYS_CTRL_AUXSRC_LSB),
        CLOCKS_CLK_SYS_CTRL_AUXSRC_BITS
    );

    if (has_glitchless_mux(clk_index)) {
        printf("has glitchless mux *1\n") ;
        hw_write_masked(&clock->ctrl,
            src << CLOCKS_CLK_REF_CTRL_SRC_LSB,
            CLOCKS_CLK_REF_CTRL_SRC_BITS
        );
        while (!(clock->selected & (1u << src)))
            tight_loop_contents();
    }

    // Enable clock. On clk_ref and clk_sys this does nothing,
    // all other clocks have the ENABLE bit in the same position.
    printf("enable clock, clock=%08XH\n",clock) ;
    hw_set_bits(&clock->ctrl, CLOCKS_CLK_GPOUT0_CTRL_ENABLE_BITS);

    // Now that the source is configured, we can trust that the user-supplied
    // divisor is a safe value.
    printf("set  clock->div =%08XH \n",div) ;

    clock->div = div;

    // Store the configured frequency
    configured_freq[clk_index] = (uint32_t)(((uint64_t) src_freq << 8) / div);
    printf("set  configured_freq[clk_index] = %d\n",configured_freq[clk_index]) ;
    printf("end clock configure()\n\n") ;
    return true;
}
/// \end::clock_configure[]




#define GPIO0 0
#define GPIO2 2
#define GPIO3 3

#include "hardware/structs/pll.h"
#include "hardware/pwm.h"

#define MHz 1000000
#define kHz 1000

void measure_freqs(void) {
  printf("\n\nMeasure frequencies:\n") ;
  uint f_pll_sys = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_PLL_SYS_CLKSRC_PRIMARY);
  uint f_pll_usb = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_PLL_USB_CLKSRC_PRIMARY);
  uint f_rosc = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_ROSC_CLKSRC);
  uint f_clk_sys = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_CLK_SYS);
  uint f_clk_peri = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_CLK_PERI);
  uint f_clk_usb = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_CLK_USB);
  uint f_clk_adc = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_CLK_ADC);
  uint f_clk_rtc = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_CLK_RTC);
  printf("pll_sys  = %dkHz\n", f_pll_sys);
  printf("pll_usb  = %dkHz\n", f_pll_usb);
  printf("rosc     = %dkHz\n", f_rosc);
  printf("clk_sys  = %dkHz\n", f_clk_sys);
  printf("clk_peri = %dkHz\n", f_clk_peri);
  printf("clk_usb  = %dkHz\n", f_clk_usb);
  printf("clk_adc  = %dkHz\n", f_clk_adc);
  printf("clk_rtc  = %dkHz\n", f_clk_rtc);
  // Can't measure clk_ref / xosc as it is the ref
  }


void busy1(){
  int k ;  
 // printf("busy1()...\n") ;
  while(1){
    k++ ;
    }
  }

volatile float xx1 ;

void busyWait1(int nn){
  xx1=1.0 ;  
 for(int k=0 ; k<nn ; k++){
    //asm volatile("nop");
    xx1=1.2345*xx1 ;
    }
  }

volatile float xx2 ;

void busyWait2(int nn){
  xx2=2.0 ;  
 for(int k=0 ; k<nn ; k++){
    //asm volatile("nop");
    xx2=1.2345*xx2 ;
    }
  }

 

void GPIOtoggle2(int nn){
  //printf("GPIOtoggle1()\n") ;
  gpio_init(GPIO2);
  gpio_set_dir(GPIO2, GPIO_OUT);
  while(1){
    gpio_put(GPIO2,1) ;
    busyWait1(nn) ;
    gpio_put(GPIO2,0) ;
    busyWait1(nn) ; 
    //sleep_ms(10) ;
    }
  }

void GPIOtoggle3(int nn){
  //printf("GPIOtoggle1()\n") ;
  gpio_init(GPIO3);
  gpio_set_dir(GPIO3, GPIO_OUT);
  while(1){
    gpio_put(GPIO3,1) ;
    busyWait2(nn) ;
    gpio_put(GPIO3,0) ;
    busyWait2(nn) ; 
    //sleep_ms(11) ;
    }
  }

void core1Do(){
 // printf("core1Do()...\n") ;
  //busy1() ;
  GPIOtoggle3(900) ;
  }

void uartSend(){
  int k ;
  while(1){
    printf("k=%d\n",k++) ;
    sleep_ms(200) ;
    }
  }

void clocksOff(){
  clock_stop(clk_usb) ;
  clock_stop(clk_rtc) ;
  clock_stop(clk_adc) ;
  clock_stop(clk_ref) ;
  clock_stop(clk_peri) ;
  }

void uart0Off(){
  uart_deinit (uart0) ;
  gpio_init(GPIO0);
  gpio_set_dir(GPIO0, GPIO_OUT);
  gpio_put(GPIO0,0) ;
  }

void PLLsOff(){
  pll_deinit (pll_usb) ;
  pll_deinit (pll_sys) ;
  }

void clkSysDivInfo(){
  int clkSysDiv=clocks_hw->clk[clk_sys].div ;
  int clkSysDivInt=clkSysDiv >> 8 ;
  int clkSysDivFrac=clkSysDiv &0xFF ;
  printf("clkSysDiv=%08XH  clkSysDivInt=%d  clkSysDivFrac=%d \n",clkSysDiv,clkSysDivInt,clkSysDivFrac) ;

  int clkSysCtrl=clocks_hw->clk[clk_sys].ctrl ;
  int auxsrc=(clkSysCtrl>>5) & 0x7 ;
  int src=clkSysCtrl & 0x1  ;
  printf("clkSysCtrl=%08XH  ",clkSysCtrl) ;
  printf("clkSysAuxsrc=%d  ",auxsrc) ;
  printf("clkSysSrc=%d\n",src) ;

  }

void setClkSysDivInt(int divInt){
  clocks_hw->clk[clk_sys].div=(divInt << 8) | (0)  ;
  clkSysDivInfo() ;
  }

void run120MHz(){
  printf("run120MHz\n") ;
  measure_freqs() ;
  printf("\nnow change settings...\n") ;sleep_ms(200) ;
  hw_clear_bits(&clocks_hw->clk[clk_sys].ctrl, CLOCKS_CLK_SYS_CTRL_SRC_BITS);
  while (clocks_hw->clk[clk_sys].selected != 0x1) { tight_loop_contents(); }
  pll_init (pll_sys, 1, 1200*MHz , 5, 2) ;
  uart_init(uart0,115200/120*125) ;

  clock_configure(clk_sys,
                    CLOCKS_CLK_SYS_CTRL_SRC_VALUE_CLKSRC_CLK_SYS_AUX,
                    CLOCKS_CLK_SYS_CTRL_AUXSRC_VALUE_CLKSRC_PLL_SYS,
                    120 * MHz,
                    120 * MHz);
  setClkSysDivInt(1) ;
  pll_deinit (pll_usb) ;
  measure_freqs() ; sleep_ms(200) ;
  clocksOff() ;
  uart0Off() ;
  GPIOtoggle2(1000) ;
  }

void run120MHzDualCore(){
  printf("run120MHzDualCore\n") ;
  measure_freqs() ;
  printf("\nnow change settings...\n") ;sleep_ms(200) ;
  hw_clear_bits(&clocks_hw->clk[clk_sys].ctrl, CLOCKS_CLK_SYS_CTRL_SRC_BITS);
  while (clocks_hw->clk[clk_sys].selected != 0x1) { tight_loop_contents(); }
  pll_init (pll_sys, 1, 1200*MHz , 5, 2) ;
  uart_init(uart0,115200/120*125) ;

  multicore_launch_core1(core1Do);
 // sleep_ms(200) ;

  clock_configure(clk_sys,
                    CLOCKS_CLK_SYS_CTRL_SRC_VALUE_CLKSRC_CLK_SYS_AUX,
                    CLOCKS_CLK_SYS_CTRL_AUXSRC_VALUE_CLKSRC_PLL_SYS,
                    120 * MHz,
                    120 * MHz);
  setClkSysDivInt(1) ;
  pll_deinit (pll_usb) ;
  measure_freqs() ; sleep_ms(200) ;
  clocksOff() ;
  uart0Off() ;
  GPIOtoggle2(1000) ;
  }



void run60MHz(){
  printf("run60MHz\n") ;
  measure_freqs() ;
  printf("\nnow change settings...\n") ;sleep_ms(200) ;
  hw_clear_bits(&clocks_hw->clk[clk_sys].ctrl, CLOCKS_CLK_SYS_CTRL_SRC_BITS);
  while (clocks_hw->clk[clk_sys].selected != 0x1) { tight_loop_contents(); }
  pll_init (pll_sys, 1, 1200*MHz , 5, 2) ;
  uart_init(uart0,115200/120*125) ;

  clock_configure(clk_sys,
                    CLOCKS_CLK_SYS_CTRL_SRC_VALUE_CLKSRC_CLK_SYS_AUX,
                    CLOCKS_CLK_SYS_CTRL_AUXSRC_VALUE_CLKSRC_PLL_SYS,
                    120 * MHz,
                    120 * MHz);
  setClkSysDivInt(2) ;
  pll_deinit (pll_usb) ;
  measure_freqs() ; sleep_ms(200) ;
  clocksOff() ;
  uart0Off() ;
  GPIOtoggle2(1000) ;
  }


void run12MHz(){
  printf("run12MHz\n") ;
  measure_freqs() ;
  printf("\nnow change settings...\n") ;sleep_ms(200) ;
 
  clock_configure(clk_sys,
                   0,
                   CLOCKS_CLK_SYS_CTRL_AUXSRC_VALUE_XOSC_CLKSRC,
                    12 * MHz,
                    12 * MHz);


  setClkSysDivInt(1) ;
  measure_freqs() ; sleep_ms(200) ;
  PLLsOff() ;
  clocksOff() ;
  uart0Off() ;
  GPIOtoggle2(1000) ;
  }

void run6MHz(){
  printf("run6MHz\n") ;
  measure_freqs() ;
  printf("\nnow change settings...\n") ;sleep_ms(200) ;
 
  clock_configure(clk_sys,
                   0,
                   CLOCKS_CLK_SYS_CTRL_AUXSRC_VALUE_XOSC_CLKSRC,
                    12 * MHz,
                    12 * MHz);


  setClkSysDivInt(2) ;
  measure_freqs() ; sleep_ms(200) ;
  PLLsOff() ;
  clocksOff() ;
  uart0Off() ;
  GPIOtoggle2(1000) ;
  }

void run1MHz(){
  printf("run1MHz\n") ;
  measure_freqs() ;
  printf("\nnow change settings...\n") ;sleep_ms(200) ;
 
  clock_configure(clk_sys,
                   0,
                   CLOCKS_CLK_SYS_CTRL_AUXSRC_VALUE_XOSC_CLKSRC,
                    12 * MHz,
                    12 * MHz);

  clkSysDivInfo() ;
  setClkSysDivInt(12) ;
  measure_freqs() ; busyWait1(1000) ;
  PLLsOff() ;
  clocksOff() ;
  uart0Off() ;
  GPIOtoggle2(1000) ;
  }

void runSlow(){
  printf("runSlow\n") ;
  measure_freqs() ;
  printf("\nnow change settings...\n") ;sleep_ms(200) ;
 
  clock_configure(clk_sys,
                   0,
                   CLOCKS_CLK_SYS_CTRL_AUXSRC_VALUE_XOSC_CLKSRC,
                    12 * MHz,
                    12 * MHz);

  clkSysDivInfo() ;
  setClkSysDivInt(1200) ;
   rosc_disable();
  measure_freqs() ; busyWait1(10) ;
  PLLsOff() ;
  clocksOff() ;
  //rosc_set_dormant(void);
 
  int rr=rosc_hw->status ;
  uart0Off() ;
  GPIOtoggle2(10) ;
  }

 void runStd(){
    printf("runStd()...\n") ;
   GPIOtoggle2(1000) ;
   }

 void runRosc(){
  printf("runRosc\n") ;
  measure_freqs() ;

  //int clkRosc = clock_get_hz(rosc) ;
  //printf("clock_get_hz(rosc) =%10.3f MHz\n",clkRosc/((float) MHz)) ;

  printf("\nnow change settings...\n") ;sleep_ms(200) ;
 
  int ok=clock_configure1(clk_sys,
                   CLOCKS_CLK_SYS_CTRL_SRC_VALUE_CLKSRC_CLK_SYS_AUX,
                   CLOCKS_CLK_SYS_CTRL_AUXSRC_VALUE_ROSC_CLKSRC,
                   //CLOCKS_CLK_SYS_CTRL_AUXSRC_VALUE_XOSC_CLKSRC,
                   // CLOCKS_CLK_SYS_CTRL_AUXSRC_VALUE_CLKSRC_PLL_USB,
                    6 * MHz,
                    6* MHz);

  printf("okClkConfigure=%d\n",ok) ;
 // clocks_hw->clk[clk_sys].ctrl=clocks_hw->clk[clk_sys].ctrl | 1 ;

  clkSysDivInfo() ;
 // setClkSysDivInt(1) ;
 setClkSysDivInt(560) ;
  measure_freqs() ; busyWait1(10) ;
  printf("measure second time:\n") ;
   measure_freqs() ; busyWait1(10) ;
 // abort() ;
  PLLsOff() ;
//  clocksOff() ;
  clock_stop(clk_usb) ;
  clock_stop(clk_rtc) ;
  clock_stop(clk_adc) ;
  clock_stop(clk_ref) ;
  clock_stop(clk_peri) ;
  xosc_disable() ;

  uart0Off() ;
  GPIOtoggle2(10) ;
  }

int main() {
  stdio_init_all();
  clock_configure(clk_peri,
                    0,
                   CLOCKS_CLK_PERI_CTRL_AUXSRC_VALUE_CLKSRC_PLL_SYS,
                    125 * MHz,
                    125 * MHz);
  // so clk_peri does not depend on clk_sys
  sleep_ms(200) ;
  printf("\n\nHello, world: picoCurrentConsumption1V01\n");
  sleep_ms(200) ;
  multicore_reset_core1() ;
  // run120MHz() ; // 20.5mA
  // run60MHz() ; // 12 mA
  // run12MHz() ; // 3.3 mA
  // run6MHz() ; // 2.5mA
  // run1MHz() ;  // 1.8mA
  // runSlow() ;  // 100 kHz 1.5mA  10kHz 1.5mA
 //  runRosc() ;
 // run120MHzDualCore() ; // 22.5mA
   runStd() ; // 26mA
  abort() ;
  }

