#define nxk 20 
#define nyk 40 

float xk[nxk] ;
//float yk[nyk] ;

float ykDef[nyk] ;
float ykRound[nyk] ;
float ykPar[nyk] ;

#define nFIR 20 

float hk[nFIR+1] ;
float roundBuffer[nFIR+1] ;

void fillXkYk(){
  printf("fillXk()...\n") ;
  for(int k=0 ; k<nxk ; k++){
    xk[k]=0.001*( rand()%1000-500) ;
  //  if(k==4){ xk[k]=1 ; } else { xk[k]=0 ; }
    printf("xk[%d]=%10.4f\n",k,xk[k]) ;
    }
  for(int k=0 ; k<nyk ; k++){
    ykDef[k]=0 ;
    ykRound[k]=0 ;
    }  
  }

void fillHk(){
  printf("fillHk()...\n") ;
  for(int k=0 ; k<=nFIR ; k++){
    hk[k]=k-2.5 ;
    printf("hk[%d]=%10.4f\n",k,hk[k]) ;
    }
  }

void convolveDef(){
  printf("convolveDef()...\n") ;   
  for(int k=0 ; k<nxk ; k++){
    float FIRsum=0 ;
    for(int i=0 ; i<=nFIR ; i++){
      if(k-i>=0){
        FIRsum=FIRsum+hk[i]*xk[k-i] ;
        }
      }
    ykDef[k]=FIRsum ;
    }
  printf("\n\n") ;  
  }

void roundBufferFIR(){
  int roundBufferPos=0 ;
  printf("\nroundBuffer implementation:\n") ; 
  for(int k=0 ; k<nxk ; k++){
    roundBuffer[roundBufferPos]=xk[k] ;
    float FIRsum ;
    int pos=roundBufferPos ;
    FIRsum=0 ;
    for(int i=0 ; i<=nFIR ; i++){
      FIRsum=FIRsum+roundBuffer[pos]*hk[i] ;
      pos-- ;
      if(pos<0){ pos=nFIR ; }
      }
    ykRound[k]=FIRsum ;
    printf("ykDef=%10.4f  ykRound=%10.4f \n",ykDef[k],ykRound[k]) ;  
    roundBufferPos++ ;
    if(roundBufferPos>nFIR){ roundBufferPos=0 ; }
    }
  }    

void parSimFIR(){
  printf("simulate parallel computation: nFIR+1=%d \n",nFIR+1) ;
  for(int j=0 ; j<nFIR+1 ; j++){ roundBuffer[j]=0 ; }
  int roundBufPos1=0 ;
  int roundBufPos2=(nFIR+1)/2 ;
  int fillPos=0 ;
  int nFIR1=(nFIR+1)/2 ;
  int nFIR2=nFIR+1-nFIR1 ;
  printf("nFIR1= %d nFIR2= %d \n",nFIR1,nFIR2) ;
  for(int k=0 ; k<nxk ; k++){
    printf("parallel k= %d  :",k) ;
    roundBuffer[fillPos]=xk[k] ;
    float FIRsum1=0 ;
    int pos1=roundBufPos1 ;
    for(int i=0 ; i<=nFIR1 ; i++){
      FIRsum1=FIRsum1+roundBuffer[pos1]*hk[i] ;
      pos1-- ;
      if(pos1<0){ pos1=nFIR ; }
      }
    float FIRsum2=0;
    int pos2=roundBufPos2 ;
    for(int i=nFIR1+1 ; i<=nFIR ; i++){
      FIRsum2=FIRsum2+roundBuffer[pos2]*hk[i] ;
      pos2-- ;
      if(pos2<0){ pos2=nFIR ; }
      }
    printf("defYk= %10.4f roundBuf %10.4f parFIR=%10.4f \n",ykDef[k],ykRound[k],FIRsum1+FIRsum2 ) ;   
    fillPos++ ;
    if(fillPos>nFIR){ fillPos=0 ; }
    roundBufPos1++ ;
    if(roundBufPos1>nFIR){ roundBufPos1=0 ; }
    roundBufPos2++ ;
    if(roundBufPos2>nFIR){ roundBufPos2=0 ; }
    }
  }

int roundBufPos1 ;
int roundBufPos2 ;
int fillPos ;
int nFIR1 ;
int nFIR2 ;
float FIRsum1 ;
float FIRsum2 ;

bool core1Trigger ;
bool core1Ready ;

inline void FIR1action(){
  FIRsum1=0 ;
  int pos1=roundBufPos1 ;
  for(int i=0 ; i<=nFIR1 ; i++){
    FIRsum1=FIRsum1+roundBuffer[pos1]*hk[i] ;
    pos1-- ;
    if(pos1<0){ pos1=nFIR ; }
    }
  roundBufPos1++ ;
  if(roundBufPos1>nFIR){ roundBufPos1=0 ; }
  }
  
inline void FIR2action (){
  FIRsum2=0;
  int pos2=roundBufPos2 ;
  for(int i=nFIR1+1 ; i<=nFIR ; i++){
    FIRsum2=FIRsum2+roundBuffer[pos2]*hk[i] ;
    pos2-- ;
    if(pos2<0){ pos2=nFIR ; }
    }
  roundBufPos2++ ;
  if(roundBufPos2>nFIR){ roundBufPos2=0 ; }
  }

 void core1FIR(){
   while(true){
    while(!core1Trigger) { }
    core1Trigger=false ;
    FIR2action() ;
    core1Ready=true ;
    }
  }

void parFIR(float xk){
  roundBuffer[fillPos]=xk ;
  core1Trigger=true ;
  FIR1action() ;
  fillPos++ ;
  if(fillPos>nFIR){ fillPos=0 ; }
  while(!core1Ready){} 
  core1Ready=false ;
  }

void serFIR(float xk){
  roundBuffer[fillPos]=xk ;
  FIR1action() ;
  FIR2action() ;
  fillPos++ ;
  if(fillPos>nFIR){ fillPos=0 ; }
  }

void runParFIR(){
  printf("parallel computation: nFIR+1=%d \n",nFIR+1) ;
  PWMmeasure1Init  
  for(int j=0 ; j<nFIR+1 ; j++){ roundBuffer[j]=0 ; }
  roundBufPos1=0 ;
  roundBufPos2=(nFIR+1)/2 ;
  fillPos=0 ;
  nFIR1=(nFIR+1)/2 ;
  nFIR2=nFIR+1-nFIR1 ;
  printf("nFIR1= %d nFIR2= %d \n",nFIR1,nFIR2) ;
  core1Trigger=false ;
  core1Ready=false ;
  for(int k=0 ; k<nxk ; k++){
    PWMmeasure1Start
    parFIR(xk[k]) ;
    PWMmeasure1Stop
    printf("parallel k= %d  :",k) ;
    printf("defYk= %10.4f roundBuf %10.4f parFIR=%10.4f \n",ykDef[k],ykRound[k],FIRsum1+FIRsum2 ) ;   
    }
  PWMmeasure1Show  
  }

void runSerFIR(){
  printf("seriell computation: nFIR+1=%d \n",nFIR+1) ;
  PWMmeasure1Init  
  for(int j=0 ; j<nFIR+1 ; j++){ roundBuffer[j]=0 ; }
  roundBufPos1=0 ;
  roundBufPos2=(nFIR+1)/2 ;
  fillPos=0 ;
  nFIR1=(nFIR+1)/2 ;
  nFIR2=nFIR+1-nFIR1 ;
  printf("nFIR1= %d nFIR2= %d \n",nFIR1,nFIR2) ;
  core1Trigger=false ;
  core1Ready=false ;
  for(int k=0 ; k<nxk ; k++){
    PWMmeasure1Start
    serFIR(xk[k]) ;
    PWMmeasure1Stop
    printf("seriell k= %d  :",k) ;
    printf("defYk= %10.4f roundBuf %10.4f serFIR=%10.4f \n",ykDef[k],ykRound[k],FIRsum1+FIRsum2 ) ;   
    }
  PWMmeasure1Show  
  }

void FIRfilterDo(){
  printf("FIRfilterDo()...\n") ;
  fillXkYk() ;
  fillHk() ;
  convolveDef() ;
  roundBufferFIR() ;
  //parSimFIR() ;
  runParFIR() ;
  runSerFIR() ;
  }