#include <stdio.h>
#include "pico/stdlib.h"
#include <stdlib.h>

//#include "hardware/structs/timer.h"
//#include "hardware/structs/systick.h"
#include "pico/multicore.h"   
//#include "pico/stdio.h"
//#include <math.h>
//#include <time.h>

#define cpuClkkHz 125000

#define us 1e-6
#define Ohm 1 
#define mW 1e-3 
#define kHz 1e3
#define ms 1e-3

void abort0(){
  printf("abort core0 idle-loop\n") ;
  while(1){}
  }

void abort1(){
  printf("abort core1 idle-loop\n") ;
  while(1){}
  }  

#include "measureTimeWithPWM.c" 

#include "FIRfilterSim.c"

void measureTime(char *text){
  int time1=time_us_32() ;
 
  int time2=time_us_32() ;
  printf("%s delay %d us\n",text,time2-time1) ;
  }

void core1Do(){
  printf("\n\nStart core1\n");
  core1FIR() ;
//  while(1){
//    measureTime("core1") ;
//    }
  } 

int main(){
  set_sys_clock_khz(cpuClkkHz, true);
  stdio_init_all();
  sleep_ms(200) ;
  printf("\n\nHello, picoFIRfilterDualCore1V01\n");
  printf("cpuClkkHz=%d\n",cpuClkkHz);
  sleep_ms(100) ;
  multicore_launch_core1(core1Do);
  main2() ;
  FIRfilterDo() ;
  abort0() ;
  }