// in order to assemble the pio file
// in project generator enable option "PIO interface"


#include <stdlib.h>
#include "pico/stdlib.h"

#include <stdio.h>
#include <math.h>
#include "hardware/dma.h"
#include "hardware/pio.h"
#include "hardware/spi.h"
#include "hardware/structs/bus_ctrl.h"
#include "hardware/pll.h"
#include <hardware\pwm.h>

#define kHz 1e3
#define MHz 1e6
#define us 1e-6

//#define cpuClkKhz 22000
//#define cpuClkKhz 125000
#define cpuClkkHz 100000

//int PIOclkDivInt16=1 ;
int PIOclkDivInt16=1 ;
int PIOclkDivFrac8=0 ;

int FracClkClkDivInt16=3 ;
int FracClkClkDivFrac8=256/3 ;

#include "gpioRead1.pio.h"

#define LEDpin 25

//#define nSamples 4096
//#define nSamples 4096
#define nSamples 16384*2
#define nPreamble 8

int preambleBuffer[nPreamble] ;
int sampleBuffer[nSamples] ;
int packedDMAbuffer[nSamples/4+nPreamble/4] ;

//---------------------------------------------------------------------------------
/*
trace 0 GPIO-2 pin  4 connected to PWMpin1 GPIO-16 pin 21    PWM clk=sysClk=100MHz, period=20, on-time 5
trace 1 GPIO-3 pin  5 connected to PIO1-bit0 GPIO-14 pin 19   50MHz clock
trace 2 GPIO-4 pin  6 connected to SPI0-SC   GPIO-18 pin 24  SPI clk=50MHz
trace 3 GPIO-5 pin  7 connected to SPI0-TX   GPIO-19 pin 25  SPI data
trace 4 GPIO-6 pin  9 connected to SPI0-CSn  GPIO-17 pin 22  SPI chip select negative
trace 5 GPIO-7 pin 10 connected to PIO2-bit0 GPIO-12 pin 16  SPI chip select negative
*/
//---------------------------------------------------------------------------------

char stxt[256] ;

void measure_freqs(void) {
  printf("\n\nMeasure frequencies:\n") ;
  uint f_pll_sys = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_PLL_SYS_CLKSRC_PRIMARY);
  uint f_pll_usb = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_PLL_USB_CLKSRC_PRIMARY);
  uint f_rosc = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_ROSC_CLKSRC);
  uint f_clk_sys = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_CLK_SYS);
  uint f_clk_peri = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_CLK_PERI);
  uint f_clk_usb = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_CLK_USB);
  uint f_clk_adc = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_CLK_ADC);
  uint f_clk_rtc = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_CLK_RTC);
 
  sprintf(stxt,"pll_sys  = %dkHz\n", f_pll_sys);printf(stxt) ;
  sprintf(stxt,"pll_usb  = %dkHz\n", f_pll_usb);printf(stxt) ;
  sprintf(stxt,"rosc     = %dkHz\n", f_rosc);printf(stxt) ;
  sprintf(stxt,"clk_sys  = %dkHz\n", f_clk_sys);printf(stxt) ;
  sprintf(stxt,"clk_peri = %dkHz\n", f_clk_peri);printf(stxt) ;
  sprintf(stxt,"clk_usb  = %dkHz\n", f_clk_usb);printf(stxt) ;
  sprintf(stxt,"clk_adc  = %dkHz\n", f_clk_adc);printf(stxt) ;
  sprintf(stxt,"clk_rtc  = %dkHz\n", f_clk_rtc);printf(stxt) ;
  }

void abort(){
  printf("\n\nabort()...\nenter endless loop\n") ;
  while(1){}  
  }
  	
#define PWMpin1 16
#define PWMpin2 17

#define PWMwrap 20
#define PWMval1 5
#define PWMval2 15

void PWMsetup(){    
  gpio_set_function(PWMpin1, GPIO_FUNC_PWM);
  gpio_set_function(PWMpin2, GPIO_FUNC_PWM);
  uint slice_num1 = pwm_gpio_to_slice_num(PWMpin1);
  uint slice_num2 = pwm_gpio_to_slice_num(PWMpin2);
  pwm_config config1 = pwm_get_default_config();
  pwm_config_set_clkdiv_int(&config1, 1);
  printf("PWM sliceNum1=%d sliceNum2=%d\n",slice_num1,slice_num2) ;
  pwm_init(slice_num1, &config1, true);
  pwm_init(slice_num2, &config1, true);
  pwm_set_wrap(slice_num1,(PWMwrap-1) );
  float fPWM=cpuClkkHz*kHz/PWMwrap ;
  printf("fPWM=%10.1f\n",fPWM) ;
  pwm_set_gpio_level(PWMpin1, PWMval1 );
  pwm_set_gpio_level(PWMpin2, PWMval2 );
  }

spi_inst_t* theSPI ;

#define SPI_SCK_PIN 18
#define SPI_TX_PIN 19
#define SPI_CS_PIN 17

#define gpio20 20

void SPIsetup(){
  printf("SPIsetup()...\n") ;
 
  theSPI=spi0 ;
  spi_init(spi_default,50000000) ;
  //spi_init(spi_default,1000000) ;
  gpio_set_function(SPI_SCK_PIN, GPIO_FUNC_SPI);
  gpio_set_function(SPI_TX_PIN, GPIO_FUNC_SPI);
  gpio_set_function(SPI_CS_PIN, GPIO_FUNC_SPI);
  spi_set_format(spi_default,16,0,0,SPI_MSB_FIRST) ;
  int baudrate=spi_get_baudrate(spi_default) ;
  printf("achieved baudrate=%d\n",baudrate) ;
  int cr0=spi_get_hw(spi0)->cr0 ;
  printf("spi cr0=%08XH\n",cr0) ;
  /*
    printf("select TI frame format\n") ;
    spi_get_hw(spi0)->cr0=0x1F ;
    cr0=spi_get_hw(spi0)->cr0 ;
    printf("spi cr0=%08XH\n",cr0) ;
  */
  }

#define nSPI 4
uint16_t spiData[nSPI] ;

void testSPI(){
  printf("run testSPI()\n") ;
  spiData[0]=0xAAAA ;
  spiData[1]=0x3333 ;
  spiData[2]=0xCCCC ;
  spiData[3]=0x5555 ;
  while(1){
    spi_write16_blocking(spi_default,spiData,nSPI) ;  
    } 
  }

uint16_t spiBuf16[8] ;

int k=0 ;

void SPIsend1(){
  spiBuf16[0] =0x5555 ;
  spiBuf16[1] =0x1234 ;
  spiBuf16[2] =0xF0F0 ;
  spiBuf16[3] =0x3333 ;
  spiBuf16[4] =0x5555 ;
  spiBuf16[5] =0x1234 ;
  spiBuf16[6] =0xF0F0 ;
  spiBuf16[7] =0x3333 ;
  spi_get_hw(spi_default)->dr = (uint32_t)spiBuf16[0];
  spi_get_hw(spi_default)->dr = (uint32_t)spiBuf16[1];
  spi_get_hw(spi_default)->dr = (uint32_t)spiBuf16[2];
  spi_get_hw(spi_default)->dr = (uint32_t)spiBuf16[3];
  spi_get_hw(spi_default)->dr = (uint32_t)spiBuf16[4];
  spi_get_hw(spi_default)->dr = (uint32_t)spiBuf16[5];
  spi_get_hw(spi_default)->dr = (uint32_t)spiBuf16[6];
  spi_get_hw(spi_default)->dr = (uint32_t)spiBuf16[7];
  }  

#define nShow 64

void showBuffer(){
  printf("Logic-Analayser CPUclk=%d kHz = sampleRate\n\n",cpuClkkHz) ;  
 
  printf("\n") ; 
  int start=0 ;
  //while(start<2048){
 //   start=1024 ;
    start=250 ;
  printf("\n\nstart=%d\n",start) ;

  printf("trace 0 : ") ;  
    for(int k=0 ; k<nShow ; k++){
      printf("%1d",sampleBuffer[k+start] & 1) ;
      }

  for(int trace=0 ; trace<8 ; trace++){
    printf("\n\n") ;
    printf("trace %1d : ",trace) ;
    for(int k=0 ; k<nShow ; k++){
      int bit=(sampleBuffer[k+start]>>trace) & 1 ;
      if(bit){ printf("-") ; } else{ printf("_") ;}
      }
    }
  start +=128 ;
 // }
  }

PIO thisPio ;
uint LAsm ;
uint FracClkSm ;

void dmaSetup() {
  printf("initialize DMA:\n") ;
  LAdma_chan = dma_claim_unused_channel(true);
  printf("dma_chan=%d\n",LAdma_chan) ;
  LAcd = dma_channel_get_default_config(LAdma_chan);
  channel_config_set_read_increment(&LAcd, false);
  channel_config_set_write_increment(&LAcd, true);
  channel_config_set_dreq(&LAcd, pio_get_dreq(thisPio, LAsm, false));

  dma_channel_configure(LAdma_chan, &LAcd,
    packedDMAbuffer,        // Destination pointer
    &thisPio->rxf[LAsm],      // Source pointer
    nSamples/4+nPreamble/4, // Number of transfers
    //  nPreamble/4+2, // Number of transfers
    false               // Start immediately
    );
  }

void dmaTest1(){
  int kk=0 ;
  printf("\ndmaTest1()\n") ;
  measure_freqs() ;  
  while(1){
    printf("run kk=%d : ",kk++) ;
    for(int k=0 ; k<nPreamble/4+nSamples/4 ; k++){
      packedDMAbuffer[k]=k ;
      }
    int trigger=true ;
    dma_channel_set_write_addr(LAdma_chan, &packedDMAbuffer, trigger) ;
    int time1=time_us_32() ;
    int mm=0 ;
    while(dma_channel_is_busy(LAdma_chan)){ 
      mm++ ; 
      if(mm%10000==0){ printf("#") ; }
      } ;
    int time2=time_us_32() ;
    printf(" dma time used=%d us dma sampleRate=%10.5f Ms/s\n",time2-time1,(float)(nSamples/((time2-time1)*us)/MHz) ) ;
    printf("mm=%d\n",mm) ;
    for(int k=nPreamble/4 ; k<nPreamble/4+8 ; k++){
      int val=packedDMAbuffer[k] &0xFF ;
      printf(" %2X",val) ;
      }
    printf("\n") ;
    sleep_ms(1000) ;
    }
  }

int main() {
  set_sys_clock_khz(cpuClkkHz, true);

  clock_configure(clk_peri,
                    0, // No GLMUX
                    CLOCKS_CLK_ADC_CTRL_AUXSRC_VALUE_CLKSRC_PLL_SYS,
                    100 * MHZ,
                    100 * MHZ);

  stdio_init_all();
  gpio_init(PWMpin1);
  gpio_set_dir(PWMpin1, GPIO_OUT);

  gpio_init(LEDpin);
  gpio_set_dir(LEDpin, GPIO_OUT);

  gpio_init(gpio20);
  gpio_set_dir(gpio20, GPIO_OUT);

  sleep_ms(500) ;
  printf("\n\npicoLogicAnalyzerPIOdma1V01.c()...\n") ;
  bus_ctrl_hw->priority = BUSCTRL_BUS_PRIORITY_DMA_W_BITS | BUSCTRL_BUS_PRIORITY_DMA_R_BITS;
  thisPio = pio0 ;

  uint LAoffset = pio_add_program(thisPio, &LApioDMAv01_program) ;
  LAsm = pio_claim_unused_sm(thisPio, true) ;
  LApio_program_init1(thisPio, LAsm, LAoffset,packedDMAbuffer,nSamples/4+nPreamble/4) ;
 
  int time1=time_us_32() ;
  int sum=0 ;
  for(int k=0 ; k<nSamples ; k++){
    asm volatile("myLabel1: "); \
    sampleBuffer[k]=gpio_get_all() ;
    //sum += gpio_get_all() ;
    }
  int time2=time_us_32() ;
  printf("sum=%d\n",sum) ;
  double rate1=((double)nSamples)/((time2-time1)*us) ;
  printf("c-program sample rate=%10.3f Ms/s\n",rate1/MHz) ;

  dmaSetup() ;

 uint FracClkOffset = pio_add_program(thisPio, &FracClkPio_program) ;
  FracClkSm = pio_claim_unused_sm(thisPio, true) ;
  FracClkPio_program_init1(thisPio, FracClkSm , FracClkOffset) ;
 
  printf("FracClkClkDivInt16=%d\n",FracClkClkDivInt16) ;
  printf("FracClkClkDivFrac8=%d\n",FracClkClkDivFrac8) ;
  
  double fCPU=((double)cpuClkkHz)*kHz ;
  double Mratio=(double)FracClkClkDivInt16+(double)FracClkClkDivFrac8/((double)256) ;
  double fOut=fCPU/Mratio/((double)2) ;
  printf("fOut=%10.6f MHz\n",fOut/MHz) ;

 // dmaTest1() ;

  PWMsetup() ;

  SPIsetup() ;

 // testSPI() ;

 // SPIsend1() ;
  measure_freqs();  
  while (true) {
 // for(int k=0 ; k<4000 ; k++){
   // printf("************************************** k=%d\ndmaTrigger...",k) ;  
    //sleep_ms(10) ;
    int trigger=true ;
    dma_channel_set_write_addr(LAdma_chan, &packedDMAbuffer, trigger) ;
    int time1=time_us_32() ;
     SPIsend1() ;    
    int mm=0 ;
    while(dma_channel_is_busy(LAdma_chan)){ 
      mm++ ; 
      } ;
    int time2=time_us_32() ;
    printf("\ndma time used=%d us dma sampleRate=%10.5f\n",time2-time1,(float)(nSamples/((time2-time1)*us)) ) ;
    printf("mm=%d\n",mm) ;

    for(int k=0 ; k<nPreamble/4 ; k++){
      preambleBuffer[4*k+0]=((packedDMAbuffer[k]>>24) & 0xFF) ;
      preambleBuffer[4*k+1]=((packedDMAbuffer[k]>>16) & 0xFF) ;  
      preambleBuffer[4*k+2]=((packedDMAbuffer[k]>>8) & 0xFF) ;
      preambleBuffer[4*k+3]=((packedDMAbuffer[k]>>0) & 0xFF) ;  
      }
    for(int k=0 ; k<nSamples/4 ; k++){
      sampleBuffer[4*k+0]=((packedDMAbuffer[k+nPreamble/4]>>24) & 0xFF) ;
      sampleBuffer[4*k+1]=((packedDMAbuffer[k+nPreamble/4]>>16) & 0xFF) ;
      sampleBuffer[4*k+2]=((packedDMAbuffer[k+nPreamble/4]>>8) & 0xFF) ;
      sampleBuffer[4*k+3]=((packedDMAbuffer[k+nPreamble/4]>>0) & 0xFF) ;
      }
    showBuffer() ;  
    sleep_ms(2000) ;
    } 

  }
