#include "pico/stdlib.h"
#include <stdio.h>
#include <math.h>
#include "pico/time.h"
#include "hardware/irq.h"
#include "hardware/pwm.h"

#define kHz 1000
#define PWM_PIN1 2

#define cpuClkkHz 125000
#define pwmWrap 128
#define nDown 5
#define SIGfrq 20000 

int fPWM=0 ;
int downCounter=0 ;
int fSample=0 ;

uint32_t DDSp ; // DDS phase value
uint32_t DDSd ; // DDS phase delta

int LOcosTab[256] ;

//------------------------------------------------------------------------------------------------------

void pwmIRQ() {
  pwm_clear_irq(pwm_gpio_to_slice_num(PWM_PIN1));
  downCounter++ ;
  if(downCounter==nDown){
    downCounter=0 ;
    DDSp += DDSd ; 
    int val1 = LOcosTab[DDSp>>24] ;
    pwm_set_gpio_level(PWM_PIN1, val1 );
    }
  }

//**************************************************************************************************************

char text[128] ;

void PWMsetup(){    
  gpio_set_function(PWM_PIN1, GPIO_FUNC_PWM);
  uint slice_num1 = pwm_gpio_to_slice_num(PWM_PIN1);

  irq_set_exclusive_handler(PWM_IRQ_WRAP, pwmIRQ);
  pwm_clear_irq(slice_num1);
  pwm_set_irq_enabled(slice_num1, true);
  irq_set_enabled(PWM_IRQ_WRAP, true);

  pwm_config config1 = pwm_get_default_config();
  pwm_config_set_clkdiv(&config1, 1.f);
  pwm_init(slice_num1, &config1, true);
  pwm_set_wrap(slice_num1,(pwmWrap-1) );
 
  printf("PWM_PIN1=%d\n",PWM_PIN1) ;
  printf("slice_num1=%d\n",slice_num1) ;
  printf("config1=%d\n",config1) ;
  printf("pwmWrap=%d\n",pwmWrap) ;
  printf("\n") ;
  }

int main() {
  set_sys_clock_khz(cpuClkkHz, true);
  stdio_init_all();
  sleep_ms(250) ;
  printf("\n\nHello picoPWMsiggen1V01 !\n") ;
  fPWM=cpuClkkHz*kHz/pwmWrap ;
  fSample=fPWM/nDown ;
  printf("fCPU=%d kHz\n",cpuClkkHz) ;
  printf("fPWM=%d\n",fPWM) ;
  printf("fSample=%d\n",fSample) ;
  printf("SIGfrq=%d Hz\n",SIGfrq) ;
  for(int k=0 ; k<256 ; k++){
    double phi=2*M_PI*k/256.0 ;
    LOcosTab[k]=pwmWrap/2.0*(1.0+0.9*cos(phi)) ;
    }
  double relFrq=((double)SIGfrq)/((double)fSample) ;
  printf("relFrq=%10.4f\n",relFrq) ;
  DDSp =0 ;
  DDSd=(int)( ((double)0x100000000L)*relFrq) ;
  printf("DDSd=%d\n",DDSd) ;
  PWMsetup() ;
  printf("idle...\n") ;
  while (1){ }
  }

