#include <stdio.h>
#include "pico/stdlib.h"
//#include "hardware/regs/m0plus.h"
#include "hardware/structs/systick.h"
   
#include "pico/stdio.h"

#define cpuClkkHz 125000

#define us 1e-6
#define Ohm 1 
#define mW 1e-3 
#define kHz 1e3
#define ms 1e-3

void abort(){
  printf("abort core0 idle-loop\n") ;
  while(1){}
  }

void xputc(char c){
  putc(c,stdout) ;
  }

void xcrlf(){
  xputc(13) ;
  xputc(10) ;
  }

void xdecout(int k){
  xputc( ((k/1000) % 10)+48 ) ;
  xputc( ((k/100) % 10)+48 ) ;
  xputc( ((k/10) % 10)+48 ) ;
  xputc( (k % 10)+48 ) ;
  xputc(32) ;
  }




#define nn 4
int counts[nn] ;

#define nops10 \
  asm volatile("nop"); \
  asm volatile("nop"); \
  asm volatile("nop"); \
  asm volatile("nop"); \
  asm volatile("nop"); \
  asm volatile("nop"); \
  asm volatile("nop"); \
  asm volatile("nop"); \
  asm volatile("nop"); \
  asm volatile("nop"); 

void sysTickDemo1V02(){
   printf("sysTickDemo1V02() measure nops10 \n") ;
   systick_hw->csr=1 | (1<<2) ;
   for(int k=0 ; k<nn ; k++){
     systick_hw->cvr=1234 ; // clear on write!
     nops10
     counts[k]=systick_hw->cvr ;
     }
   for(int k=0 ; k<nn ; k++){
     int count=0xFFFFFF-counts[k] ;
     printf("k=%2d count=%5d\n",k,count) ;
     }  
   }

int counts1 ;

#define sysTickDemo1V03 \
  systick_hw->cvr=1234 ; \
 nops10 \
  counts1=systick_hw->cvr ;\
  counts1=0xFFFFFF-counts1 ;\
  xdecout(counts1) ; xcrlf() ; 

void sysTickDemo1V03rep(){
  printf("sysTickDemo1V03rep()...\n") ;
  sysTickDemo1V03
  sysTickDemo1V03
  sysTickDemo1V03  
  }

void sysTickDemo1V04(){
  systick_hw->cvr=1234 ; // clear on write!
//  nops10
   counts1=systick_hw->cvr ;
   counts1=0xFFFFFF-counts1 ;
   printf("counts=%5d\n",counts1) ;
   }   

void sysTickDemo1V01(){
   systick_hw->csr=1 | (1<<2) ;
   int t1=systick_hw->cvr ;
   sleep_ms(1) ;
   int t2=systick_hw->cvr ;
   printf("1ms=%5d ticks\n",t1-t2) ;
   }

void sysTickDemo1V01rep(){
  printf("sysTickDemo1V01rep()...\n") ;
  sysTickDemo1V01() ;
  sysTickDemo1V01() ;
  sysTickDemo1V01() ;  
  }

int main(){
  set_sys_clock_khz(cpuClkkHz, true);
  stdio_init_all();
  sleep_ms(200) ;
  printf("\n\nHello, picoSysTickDem0V01\n");
  printf("cpuClkkHz=%d\n",cpuClkkHz);
  
  float maxTime=(2<<24)/((float)cpuClkkHz*kHz) ;
  printf("maxTime=2^24/CLOCK=%10.4f ms\n",maxTime/ms) ;

  int reload=systick_hw->rvr ; 
  printf("reload=%08XH \n",reload) ;

  /*
  
  sysTickDemo1V03 
  sysTickDemo1V03rep() ; 
  sysTickDemo1V01rep() ;   
*/  

  sysTickDemo1V01() ;   
  sysTickDemo1V02() ;     

   
  
  abort() ;
  }
