#include "hardware/regs/addressmap.h"
#include "hardware/regs/sio.h"

.section ".scratch_x.", "ax"
@
@ Assembler function interpRectDDSloop
@
@ R1 - DAC port address
@ R2 - Bit Val from interp_pop
@ R3 - address of siobase / interp0 POP
@

.global interpRectDDSloop 		@ Provide function starting address 

.thumb_func                     @ Needed since SDK uses BX to call us
interpRectDDSloop:
    LDR   R3, interp_pop 
	LDR   R1, siobase                 @ address we want
	ADD   R1, #SIO_GPIO_OUT_OFFSET    @ DAC port address
loop:	
	LDR   R2, [R3]  @ pop bit from interp0                     1 cyc. 
	STRB  R2, [R1]	               @ send to port              1 cyc. 	
	B     loop 		   	           @ loop for ever             2 cyc.
						           @                     total 4 cycles  	
@	MOV   PC,R4                    @ also needs 2 cycles

@---------------------------------------------------------------------------------------------

.global DDSasm

.thumb_func        
DDSasm: 
  @ set default value for delta (1kHz)
	LDR R0, adr_ddsdelta  @ address we want
	LDR R4, [R0] 		  @ set delta                
	MOV R1, #0            @ initialize phase akku
	LDR R0, siobase       @ address we want
	ADD   R0, #SIO_GPIO_OUT_OFFSET    @ DAC port address
loop2:
	ADD  R1, R4           @ Add delta to phase akku   1 cyc.
	LSR  R3, R1, #31 	  @ shift right for output    1 cyc. 
	STRB R3, [R0]	      @ send to port              1 cyc. 	
	B  loop2 		   	  @ loop for ever             2 cyc.
	

@---------------------------------------------------------------------------------------------

.align 4 

interp_pop: .word SIO_BASE +  SIO_INTERP0_POP_FULL_OFFSET	
siobase: .word SIO_BASE @ base of the GPIO registers
adr_ddsdelta: .word ddsdelta

@.data
@.section ".scratch_x.", "ax"

.align 4
ddsdelta:
    .word 17179870  @ 100kHz for 125MHz/5
	