#include <stdio.h>
 #include <string.h>
 #include <math.h>
 #include <time.h>
 #include "pico/stdlib.h"
 #include "pico/multicore.h"
 #include "hardware/gpio.h"
 #include "pico/binary_info.h"
 //#include "hardware/irq.h" 
 #include "hardware/interp.h"
  
#define gpio0 0 
#define MHz 1e6
#define kHz 1e3

#define cpuClkKhz 125000

#include "interpRectDDS.c"

extern "C" void DDSasm(void);

void asmCore1(){
  printf("start asmCore1()...\n") ;
  DDSasm() ;
  }
 
uint32_t ddsPhase ;
uint32_t ddsDelta ;


void cDDS(){
  printf("cDDS()...\n") ;
  double ddsclk = 1000.0*cpuClkKhz/18.0 ;
  double frq=75*kHz ;
  ddsDelta=(uint32_t)((frq*4294967296.0)/ddsclk) ;	
  printf("ddeDelta=%d\n",ddsDelta) ;
  ddsPhase=0 ;
  while(1){
    asm volatile("cLabel1:");
    ddsPhase += ddsDelta ;
    gpio_put_all(ddsPhase >> 31);
    }
  }

int main() {
  set_sys_clock_khz(cpuClkKhz, true);
  stdio_init_all();
  gpio_init(gpio0);
  gpio_set_dir(gpio0, GPIO_OUT);
  cDDS()  ;
  //interpRectDDStest() ;

  //multicore_launch_core1(asmCore1);
  abort() ;
  }
